/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.composites;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileActionHelper;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.mobile.helper.MobileScreenCaptor;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileHighlightComposite {
    private final Logger logger = LoggerFactory.getLogger(MobileHighlightComposite.class);
    private MobileElementInspectorDialog parentDialog;
    private Label lblMessageVerifyObject;
    private CapturedMobileElement editingElement;
    private Button btnHighlight;
    private Button btnAddScreenshot;
    private boolean isFinding;
    private WebElement foundWebElement;

    public MobileHighlightComposite(MobileElementInspectorDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Composite createComposite(Composite parent) {
        Composite elementToolsComposite = new Composite(parent, 0);
        elementToolsComposite.setLayout((Layout)new GridLayout(1, false));
        elementToolsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblMessageVerifyObject = new Label(elementToolsComposite, 16448);
        GridData lblMessageVerifyObjectData = new GridData(4, 128, true, false);
        lblMessageVerifyObjectData.heightHint = 20;
        this.lblMessageVerifyObject.setLayoutData((Object)lblMessageVerifyObjectData);
        Composite buttonsComposite = new Composite(elementToolsComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnHighlight = new Button(buttonsComposite, 0);
        this.btnHighlight.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnHighlight.setText(ComposerMobileObjectspyMessageConstants.DIA_BTN_HIGHLIGHT);
        this.btnHighlight.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_HIGHLIGHT_BUTTON);
        this.btnHighlight.setEnabled(false);
        this.btnHighlight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileHighlightComposite.this.findAndHighlightEditingElement();
            }
        });
        this.btnAddScreenshot = new Button(buttonsComposite, 0);
        this.btnAddScreenshot.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnAddScreenshot.setText(ComposerMobileObjectspyMessageConstants.DIA_BTN_ADD_SCREENSHOT);
        this.btnAddScreenshot.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_ADD_SCREENSHOT_BUTTON);
        this.btnAddScreenshot.setEnabled(false);
        this.btnAddScreenshot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileHighlightComposite.this.addScreenshotForEditingElement();
            }
        });
        return elementToolsComposite;
    }

    private void findAndHighlightEditingElement() {
        LocatorStrategy locatorStrategy = this.editingElement.getLocatorStrategy();
        String locatorStrategyName = locatorStrategy.getName();
        String locator = this.editingElement.getLocator();
        Thread thread = new Thread(() -> {
            block9: {
                this.isFinding = true;
                this.foundWebElement = null;
                UISynchronizeService.syncExec(() -> {
                    this.clearMessage();
                    this.refreshButtonStates();
                });
                if (this.editingElement == null) {
                    return;
                }
                UISynchronizeService.syncExec(() -> this.displayWaitMessage(locatorStrategyName, locator));
                try {
                    long startTime = System.currentTimeMillis();
                    List<WebElement> webElements = this.findElements(this.editingElement);
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    if (webElements != null && webElements.size() > 0) {
                        List elementRects = webElements.stream().map(webElement -> {
                            Point location = webElement.getLocation();
                            Dimension size = webElement.getSize();
                            double ratio = this.parentDialog.getInspectorController().getDriver() instanceof IOSDriver ? 2 : 1;
                            return new Rectangle(MobileHighlightComposite.safeRoundDouble((double)location.x * ratio), MobileHighlightComposite.safeRoundDouble((double)location.y * ratio), MobileHighlightComposite.safeRoundDouble((double)size.width * ratio), MobileHighlightComposite.safeRoundDouble((double)size.height * ratio));
                        }).collect(Collectors.toList());
                        UISynchronizeService.syncExec(() -> this.parentDialog.highlightElementRects(elementRects));
                        if (webElements.size() == 1) {
                            this.foundWebElement = webElements.get(0);
                        }
                    }
                    UISynchronizeService.syncExec(() -> {
                        if (webElements != null && webElements.size() > 0) {
                            this.displayFoundMessage(webElements.size(), locatorStrategyName, locator, elapsedTime);
                        } else {
                            this.displayNotFoundMessage(locatorStrategyName, locator);
                        }
                    });
                }
                catch (NoSuchElementException noSuchElementException) {
                    UISynchronizeService.syncExec(() -> this.displayNotFoundMessage(locatorStrategyName, locator));
                    UISynchronizeService.syncExec(() -> {
                        this.isFinding = false;
                        this.refreshButtonStates();
                    });
                    break block9;
                }
                catch (Exception exception) {
                    try {
                        UISynchronizeService.syncExec(() -> this.displayNotFoundMessage(locatorStrategyName, locator));
                    }
                    catch (Throwable throwable) {
                        UISynchronizeService.syncExec(() -> {
                            this.isFinding = false;
                            this.refreshButtonStates();
                        });
                        throw throwable;
                    }
                    UISynchronizeService.syncExec(() -> {
                        this.isFinding = false;
                        this.refreshButtonStates();
                    });
                    break block9;
                }
                UISynchronizeService.syncExec(() -> {
                    this.isFinding = false;
                    this.refreshButtonStates();
                });
            }
        });
        thread.start();
    }

    private void addScreenshotForEditingElement() {
        try {
            AppiumDriver driver = this.parentDialog.getInspectorController().getDriver();
            BufferedImage bufferedImage = MobileScreenCaptor.takeElementScreenshot((AppiumDriver)driver, (WebElement)this.foundWebElement, null, null);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            byte[] imageBytes = outputStream.toByteArray();
            String base64 = Base64.getEncoder().encodeToString(imageBytes);
            if (StringUtils.isNotEmpty((CharSequence)base64)) {
                this.editingElement.getAttributes().put("image", base64);
                this.editingElement.getLocatorCollection().put(LocatorStrategy.IMAGE, base64);
                UISynchronizeService.syncExec(() -> {
                    this.parentDialog.setEdittingElement(this.editingElement);
                    this.displaySuccessfulMessage(ComposerMobileObjectspyMessageConstants.MSG_SCREENSHOT_TAKEN);
                });
            }
        }
        catch (Exception e) {
            this.logger.error(ComposerMobileObjectspyMessageConstants.MSG_FAILED_TO_TAKE_SCREENSHOT, (Throwable)e);
        }
    }

    private List<WebElement> findElements(CapturedMobileElement targetElement) throws Exception {
        if (targetElement == null) {
            return null;
        }
        MobileTestObject mobileTestObject = targetElement.toMobileTestObject();
        AppiumDriver driver = this.parentDialog.getInspectorController().getDriver();
        MobileActionHelper mobileActionHelper = new MobileActionHelper(driver);
        return mobileActionHelper.findElements((TestObject)mobileTestObject, 1);
    }

    private void displaySuccessfulMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getTextSuccessfulColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayWarningMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getWarningForegroudColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayErrorMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getTextErrorColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayFoundMessage(int numElements, String strategy, String selector, long elapsedTime) {
        String pluralPostfix = numElements > 1 ? "s" : "";
        this.displaySuccessfulMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_ELEMENT_FOUND, numElements, pluralPostfix, strategy, selector, elapsedTime));
    }

    private void displayWaitMessage(String strategy, String selector) {
        this.displayWarningMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_SEARCHING_FOR_ELEMENTS, strategy, selector));
    }

    private void displayNotFoundMessage(String strategy, String selector) {
        this.displayErrorMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_ELEMENT_NOT_FOUND, strategy, selector));
    }

    private void clearMessage() {
        this.lblMessageVerifyObject.setText("");
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    public CapturedMobileElement getEditingElement() {
        return this.editingElement;
    }

    public void setEditingElement(CapturedMobileElement editingElement) {
        if (editingElement != null && !editingElement.equals(this.editingElement)) {
            this.foundWebElement = null;
        }
        this.editingElement = editingElement;
        this.refreshButtonStates();
        this.clearMessage();
    }

    private void refreshButtonStates() {
        boolean isEnableHightlightButton = !this.isFinding && this.editingElement != null;
        this.btnHighlight.setEnabled(isEnableHightlightButton);
        boolean canAddScreenshot = this.foundWebElement != null && this.editingElement != null;
        this.btnAddScreenshot.setEnabled(canAddScreenshot);
    }

    private static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }
}

