/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.codeassist;

import com.kms.katalon.composer.codeassist.proposal.CheckpointIDProposalProvider;
import com.kms.katalon.composer.codeassist.proposal.KatalonBuitInKeywordAliasProposal;
import com.kms.katalon.composer.codeassist.proposal.KatalonLocalVariableProposal;
import com.kms.katalon.composer.codeassist.proposal.KatalonMethodNodeProposal;
import com.kms.katalon.composer.codeassist.proposal.ProposalProvider;
import com.kms.katalon.composer.codeassist.proposal.TestCaseIDProposalProvider;
import com.kms.katalon.composer.codeassist.proposal.TestDataIDProposalProvider;
import com.kms.katalon.composer.codeassist.proposal.TestObjectIDProposalProvider;
import com.kms.katalon.composer.codeassist.util.KatalonContextUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;

public class KatalonProposalProvider
implements IProposalProvider {
    public List<IGroovyProposal> getStatementAndExpressionProposals(ContentAssistContext context, ClassNode completionType, boolean isStatic, Set<ClassNode> categories) {
        TestCaseEntity testCaseEntity;
        ClassNode enclosingGroovyType;
        ArrayList<IGroovyProposal> groovyProposals = new ArrayList<IGroovyProposal>();
        String completionExpression = StringUtils.trimToEmpty((String)context.completionExpression);
        if (KatalonContextUtil.isBuiltinKeywordCompletionClassNode(context)) {
            ClassNode classNode = new ClassNode(KatalonContextUtil.getBuiltInKeywordCompletionClassNode(context).getType());
            for (MethodNode methodNode : classNode.getAllDeclaredMethods()) {
                if (!StringUtils.startsWithIgnoreCase((String)methodNode.getName(), (String)completionExpression.trim()) || !this.isKeywordNode(methodNode)) continue;
                groovyProposals.add((IGroovyProposal)new KatalonMethodNodeProposal(methodNode));
            }
        }
        if (KatalonContextUtil.isCustomKeywordCompletionClassNode(context)) {
            try {
                for (MethodNode methodNode : KeywordController.getInstance().getCustomKeywords(ProjectController.getInstance().getCurrentProject())) {
                    groovyProposals.add((IGroovyProposal)new KatalonMethodNodeProposal(methodNode));
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        if (completionType.equals((Object)(enclosingGroovyType = context.getEnclosingGroovyType())) && (testCaseEntity = KatalonContextUtil.isTestCaseScriptContext(context)) != null) {
            for (String variableName : KatalonContextUtil.getTestCaseVariableStrings(testCaseEntity)) {
                if (!variableName.contains(context.getPerceivedCompletionExpression())) continue;
                KatalonLocalVariableProposal testCaseVariableProposal = new KatalonLocalVariableProposal(variableName);
                groovyProposals.add((IGroovyProposal)testCaseVariableProposal);
            }
        }
        for (KeywordClass keywordClass : KeywordController.getInstance().getBuiltInKeywordClasses()) {
            if (!StringUtils.startsWithIgnoreCase((String)keywordClass.getAliasName(), (String)StringUtils.trimToEmpty((String)context.fullCompletionExpression))) continue;
            groovyProposals.add((IGroovyProposal)new KatalonBuitInKeywordAliasProposal(keywordClass));
        }
        if (isStatic && enclosingGroovyType != null && !completionType.equals((Object)enclosingGroovyType) && !completionType.isRedirectNode()) {
            for (MethodNode methodNode : completionType.getMethods()) {
                if (!methodNode.isPublic()) continue;
                groovyProposals.add((IGroovyProposal)new KatalonMethodNodeProposal(methodNode));
            }
        }
        groovyProposals.addAll(this.collectArtifactIDProposals(context, completionType));
        return groovyProposals;
    }

    private List<IGroovyProposal> collectArtifactIDProposals(ContentAssistContext context, ClassNode completionType) {
        ProposalProvider[] proposalProviders = new ProposalProvider[]{new TestCaseIDProposalProvider(), new TestObjectIDProposalProvider(), new TestDataIDProposalProvider(), new CheckpointIDProposalProvider()};
        ArrayList<IGroovyProposal> artifactIDProposals = new ArrayList<IGroovyProposal>();
        ProposalProvider[] proposalProviderArray = proposalProviders;
        int n = proposalProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ProposalProvider provider = proposalProviderArray[n2];
            artifactIDProposals.addAll(provider.getProposals(context, completionType));
            ++n2;
        }
        return artifactIDProposals;
    }

    public List<MethodNode> getNewMethodProposals(ContentAssistContext context) {
        return Collections.emptyList();
    }

    public List<String> getNewFieldProposals(ContentAssistContext context) {
        return Collections.emptyList();
    }

    private boolean isKeywordNode(MethodNode methodNode) {
        if (!methodNode.isStatic() || !methodNode.isPublic()) {
            return false;
        }
        for (AnnotationNode annotatedNode : methodNode.getAnnotations()) {
            if (!annotatedNode.getClassNode().getName().equals(Keyword.class.getName())) continue;
            return true;
        }
        return false;
    }
}

