/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference.composite;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.integration.azure.component.AzureStatusEditingSupport;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.setting.ExecutionStatusMapping;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class StatusMappingTable
extends Composite {
    private TableViewer tvMain;
    private List<ExecutionStatusMapping> statusMapping;

    public StatusMappingTable(Composite parent) {
        super(parent, 2048);
        GridData ldTableComposite = new GridData(4, 4, true, false);
        this.setLayoutData(ldTableComposite);
        this.createContents(this);
    }

    private void createContents(Composite parent) {
        this.tvMain = new TableViewer(parent, 67584);
        this.tvMain.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table tMain = this.tvMain.getTable();
        tMain.setHeaderVisible(true);
        tMain.setLinesVisible(ControlUtils.shouldLineVisble((Display)tMain.getDisplay()));
        TableViewerColumn cvKatalonStatus = new TableViewerColumn(this.tvMain, 16384);
        TableColumn cKatalonStatus = cvKatalonStatus.getColumn();
        cKatalonStatus.setText(StringConstants.COLUMN_KATALON_STATUS_MAPPING);
        TableViewerColumn cvAzureStatus = new TableViewerColumn(this.tvMain, 0);
        TableColumn cAzureStatus = cvAzureStatus.getColumn();
        cAzureStatus.setText(StringConstants.COLUMN_AZURE_STATUS_MAPPING);
        cvAzureStatus.setEditingSupport((EditingSupport)new AzureStatusEditingSupport(this.tvMain));
        this.tvMain.setLabelProvider((IBaseLabelProvider)new ExecutionStatusMappingTableLabelProvider());
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)cKatalonStatus, (ColumnLayoutData)new ColumnWeightData(1, 25));
        tableColumnLayout.setColumnData((Widget)cAzureStatus, (ColumnLayoutData)new ColumnWeightData(1, 25));
        this.setLayout((Layout)tableColumnLayout);
    }

    public void setInput(List<ExecutionStatusMapping> statusMapping) {
        this.statusMapping = statusMapping;
        this.tvMain.setInput(statusMapping);
    }

    public List<ExecutionStatusMapping> getInput() {
        return this.statusMapping;
    }

    private class ExecutionStatusMappingTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int COLUMN_KATALON_STATUS_IDX = 0;
        private static final int COLUMN_AZURE_STATUS_IDX = 1;

        private ExecutionStatusMappingTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex < 0 || columnIndex > 1) {
                return "";
            }
            if (!(element instanceof ExecutionStatusMapping)) {
                return "";
            }
            ExecutionStatusMapping node = (ExecutionStatusMapping)element;
            switch (columnIndex) {
                case 0: {
                    return StringUtils.capitalize((String)node.getKatalonStatus().toString().toLowerCase());
                }
                case 1: {
                    return node.getAzureStatus();
                }
            }
            return "";
        }
    }
}

