/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.view.testcase;

import com.kms.katalon.composer.integration.azure.component.AzureVerifyTestCasesJob;
import com.kms.katalon.composer.integration.azure.component.AzureVerifyTestCasesResult;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.composer.testcase.parts.integration.AbstractTestCaseIntegrationView;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.integration.IntegratedType;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.util.EntityTagUtil;
import com.kms.katalon.integration.azure.AzureIntegrationUtil;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureTestPlanRef;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AzureIntegrationTestCaseView
extends AbstractTestCaseIntegrationView {
    private Composite container;
    private Text txtTestCaseId;
    private Button btnVerify;
    private boolean onIntegrationChanged = false;
    private Label lblVerifyStatus;
    AzureSettingStore settingStore;
    String integratedValue = "";

    public AzureIntegrationTestCaseView(TestCaseEntity testCaseEntity, MPart mpart) {
        super(testCaseEntity, mpart);
    }

    public Composite createContainer(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        this.container.setLayout((Layout)glContainer);
        Label lblTestCaseId = new Label(this.container, 0);
        lblTestCaseId.setText(StringConstants.LBL_INTEGRATION_TAB_TEST_CASE_ID);
        lblTestCaseId.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        this.txtTestCaseId = new Text(this.container, 2048);
        GridData ldTxtTestCaseId = new GridData();
        ldTxtTestCaseId.widthHint = 200;
        this.txtTestCaseId.setLayoutData((Object)ldTxtTestCaseId);
        this.txtTestCaseId.setText(this.integratedValue);
        this.btnVerify = new Button(this.container, 0);
        GridData ldBtnVerify = new GridData();
        ldBtnVerify.widthHint = 100;
        this.btnVerify.setLayoutData((Object)ldBtnVerify);
        this.btnVerify.setText(StringConstants.BTN_VERIFY);
        this.lblVerifyStatus = new Label(this.container, 64);
        this.lblVerifyStatus.setText("");
        this.lblVerifyStatus.setLayoutData((Object)new GridData(4, 0, true, true, 2, 1));
        this.initializeData();
        this.registerControlModifyListeners();
        return this.container;
    }

    private void registerControlModifyListeners() {
        this.txtTestCaseId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AzureIntegrationTestCaseView.this.onIntegrationChanged = true;
                AzureIntegrationTestCaseView.this.setDirty(true);
                AzureIntegrationTestCaseView.this.btnVerify.setEnabled(!StringUtils.isEmpty((CharSequence)AzureIntegrationTestCaseView.this.txtTestCaseId.getText()));
            }
        });
        this.btnVerify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AzureIntegrationTestCaseView.this.clearMessage();
                AzureIntegrationTestCaseView.this.performVerify();
            }
        });
    }

    private void initializeData() {
        IntegratedEntity integratedEntity = AzureIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.testCaseEntity);
        if (integratedEntity != null && integratedEntity.getProperties() != null) {
            String value = (String)integratedEntity.getProperties().get(StringConstants.AZURE_TEST_CASE_IDS);
            if (!StringUtils.isEmpty((CharSequence)value)) {
                this.txtTestCaseId.setText(value);
                this.btnVerify.setEnabled(true);
            } else {
                this.btnVerify.setEnabled(false);
            }
        }
        this.settingStore = AzureSettingStore.getStore();
    }

    private void performVerify() {
        String rawTestCaseIds = this.txtTestCaseId.getText();
        Set testCaseIds = EntityTagUtil.parse((String)(rawTestCaseIds = this.parseVariablesFromInput(rawTestCaseIds, this.testCaseEntity)));
        if (testCaseIds == null || testCaseIds.size() <= 0) {
            this.showErrorMessage(StringConstants.MSG_TEST_CASE_ID_EMPTY);
            return;
        }
        AzureVerifyTestCasesJob verifyJob = new AzureVerifyTestCasesJob(this.container.getShell(), this.getCredential(), this.getProject(), this.getTestPlans(), rawTestCaseIds);
        AzureVerifyTestCasesResult result = verifyJob.run();
        if (result.areAllValid()) {
            this.showSuccessMessage();
        } else {
            this.showErrorMessage(result.getMessage());
        }
    }

    private String parseVariablesFromInput(String inputWithVariables, TestCaseEntity testCaseEntity) {
        if (!inputWithVariables.contains("$")) {
            return inputWithVariables;
        }
        List testCaseVariables = testCaseEntity.getVariables();
        HashMap variableMap = new HashMap();
        testCaseVariables.forEach(variable -> variableMap.put(variable.getName(), variable.getDefaultValue()));
        StrSubstitutor sub = new StrSubstitutor(variableMap);
        return this.escapeValueFromListOrStringFormat(sub.replace(inputWithVariables));
    }

    private String escapeValueFromListOrStringFormat(String value) {
        return value.replace("[", "").replace("]", "").replace("'", "");
    }

    public IntegratedEntity getEditingIntegrated() {
        IntegratedEntity integratedEntity = new IntegratedEntity();
        integratedEntity.setProductName(GlobalStringConstants.AZURE_DEVOPS_NAME);
        integratedEntity.setType(IntegratedType.TESTCASE);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(StringConstants.AZURE_TEST_CASE_IDS, this.txtTestCaseId.getText());
        integratedEntity.setProperties(properties);
        return integratedEntity;
    }

    public boolean needsSaving() {
        return this.onIntegrationChanged;
    }

    private AzureCredential getCredential() {
        boolean isEncyptionEnabled = this.settingStore.isEncryptionEnabled();
        AzureCredential credential = new AzureCredential();
        credential.setServerUrl(this.settingStore.getServerUrl());
        credential.setToken(this.settingStore.getToken(isEncyptionEnabled));
        return credential;
    }

    private AzureProjectRef getProject() {
        return this.settingStore.getIntegratedProject();
    }

    private AzureTestPlanRef[] getTestPlans() {
        return this.settingStore.getAzureTestPlans();
    }

    public void clearMessage() {
        this.lblVerifyStatus.setText("");
        this.lblVerifyStatus.requestLayout();
    }

    public void showSuccessMessage() {
        this.lblVerifyStatus.setForeground(this.lblVerifyStatus.getDisplay().getSystemColor(6));
        this.lblVerifyStatus.setText(StringConstants.MSG_SUCCESS_FETCHING_TEST_CASE);
        this.lblVerifyStatus.requestLayout();
    }

    public void showErrorMessage(String message) {
        this.lblVerifyStatus.setForeground(this.lblVerifyStatus.getDisplay().getSystemColor(4));
        this.lblVerifyStatus.setText(message);
        this.lblVerifyStatus.requestLayout();
    }
}

