/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public interface IConsoleLauncher
extends ILauncher {
    public static final int ONE_HUNDRED = 100;

    public String getStatusMessage(int var1);

    default public String getDefaultStatusMessage(int consoleWidth) {
        String launcherName = this.getName();
        StringBuilder builder = new StringBuilder(launcherName).append(this.getStatusFormat(this.getResult()));
        builder.insert(launcherName.length(), StringUtils.repeat((String)".", (int)(consoleWidth - builder.length() % consoleWidth)));
        return StringUtil.wrap(builder.toString(), consoleWidth);
    }

    default public String getStatusFormat(ILauncherResult launcherResult) {
        return launcherResult.getExecutedTestCases() + "/" + launcherResult.getTotalTestCases() + "(" + this.getStatusByPercentage(launcherResult) + "%)";
    }

    default public String getStatusByPercentage(ILauncherResult launcherResult) {
        return Integer.toString(Math.round((float)launcherResult.getExecutedTestCases() / (float)launcherResult.getTotalTestCases() * 100.0f));
    }
}

