/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.db.DatabaseSettings;
import com.kms.katalon.core.db.ListResultSetHandler;
import com.kms.katalon.core.db.SqlRunner;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseController {
    private static DatabaseController instance;

    public static DatabaseController getInstance() {
        if (instance == null) {
            instance = new DatabaseController();
        }
        return instance;
    }

    public DatabaseConnection getGlobalDatabaseConnection() throws IOException {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        return new DatabaseSettings(currentProject.getFolderLocation()).getDatabaseConnection();
    }

    public DatabaseConnection getDatabaseConnection(boolean isUsingGlobalDBSetting, boolean isSecureUserAccount, String user, String password, String connectionUrl) throws IOException {
        if (isUsingGlobalDBSetting) {
            return this.getGlobalDatabaseConnection();
        }
        if (isSecureUserAccount) {
            return new DatabaseConnection(connectionUrl, user, Base64.decode((String)password));
        }
        return new DatabaseConnection(connectionUrl);
    }

    public DatabaseConnection getDatabaseConnection(boolean isUsingGlobalDBSetting, boolean isSecureUserAccount, String user, String password, String connectionUrl, String driverClassName, Properties properties) throws IOException {
        if (isUsingGlobalDBSetting) {
            return this.getGlobalDatabaseConnection();
        }
        if (isSecureUserAccount) {
            DatabaseConnection connection = new DatabaseConnection(connectionUrl, user, Base64.decode((String)password), driverClassName);
            if (properties != null) {
                connection.setConnectionProperties(properties);
            }
            return connection;
        }
        return new DatabaseConnection(connectionUrl, driverClassName);
    }

    public ResultSet query(DatabaseConnection dbConnection, String sqlQuery) throws SQLException {
        return this.query(dbConnection, sqlQuery, (Object[])null);
    }

    public ResultSet query(DatabaseConnection dbConnection, String sqlQuery, Object[] params) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SqlRunner runner = new SqlRunner(dbConnection, sqlQuery, params);){
            return runner.query();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <T> T query(DatabaseConnection dbConnection, String sqlQuery, ListResultSetHandler<T> resultSetHandler) throws SQLException {
        return this.query(dbConnection, sqlQuery, null, resultSetHandler);
    }

    public <T> T query(DatabaseConnection dbConnection, String sqlQuery, Object[] params, ListResultSetHandler<T> resultSetHandler) throws SQLException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (SqlRunner runner = new SqlRunner(dbConnection, sqlQuery, params);){
            return (T)runner.query(resultSetHandler);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

