/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.dal.ITestCaseDataProvider;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TestCaseController
extends EntityController {
    private static EntityController _instance;

    private TestCaseController() {
    }

    public static TestCaseController getInstance() {
        if (_instance == null) {
            _instance = new TestCaseController();
        }
        return (TestCaseController)_instance;
    }

    public void getOrCreateGroovyScriptForTestCase(TestCaseEntity testCase) throws ControllerException {
        try {
            GroovyUtil.getOrCreateGroovyScriptForTestCaseFromPlugin((TestCaseEntity)testCase);
        }
        catch (IOException | CoreException e) {
            throw new ControllerException(e);
        }
    }

    public TestCaseEntity newTestCase(FolderEntity parentFolder, String testCaseName) throws ControllerException {
        try {
            return this.saveNewTestCase(this.newTestCaseWithoutSave(parentFolder, testCaseName));
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public TestCaseEntity newTestCaseWithoutSave(FolderEntity parentFolder, String testCaseName) throws Exception {
        if (parentFolder == null) {
            return null;
        }
        if (StringUtils.isBlank((String)testCaseName)) {
            testCaseName = StringConstants.CTRL_NEW_TEST_CASE;
        }
        TestCaseEntity newTestCase = new TestCaseEntity();
        newTestCase.setTestCaseGuid(Util.generateGuid());
        newTestCase.setName(this.getAvailableTestCaseName(parentFolder, testCaseName));
        newTestCase.setParentFolder(parentFolder);
        newTestCase.setProject(parentFolder.getProject());
        return newTestCase;
    }

    public TestCaseEntity saveNewTestCase(TestCaseEntity newTestCase) throws ControllerException {
        if (newTestCase == null || newTestCase.getProject() == null || newTestCase.getParentFolder() == null) {
            return null;
        }
        try {
            return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().saveNewTestCase(newTestCase);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public TestCaseEntity getTestCase(String testCasePK) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getTestCase(testCasePK);
    }

    public void deleteTestCase(TestCaseEntity testCase) throws Exception {
        TestCaseController.getDataProviderSetting().getTestCaseDataProvider().deleteTestCase(testCase);
    }

    public TestCaseEntity updateTestCase(TestCaseEntity testCase) throws Exception {
        return this.updateTestCase(testCase, ITestCaseDataProvider.ReferenceUpdateOption.UPDATE_REFERENCE);
    }

    public TestCaseEntity updateTestCase(TestCaseEntity testCase, ITestCaseDataProvider.ReferenceUpdateOption referenceUpdateOption) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().updateTestCase(testCase, referenceUpdateOption);
    }

    public TestCaseEntity copyTestCase(TestCaseEntity testCaseEntity, FolderEntity destinationFolder) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().copyTestCase(testCaseEntity, destinationFolder);
    }

    public TestCaseEntity moveTestCase(TestCaseEntity testCaseEntity, FolderEntity destinationFolder) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().moveTestCase(testCaseEntity, destinationFolder);
    }

    public TestCaseEntity renameTestCase(TestCaseEntity testCaseEntity, String newName) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().renameTestCase(testCaseEntity, newName);
    }

    public List<String> getSibblingTestCaseNames(TestCaseEntity testCase) throws Exception {
        List<TestCaseEntity> sibblingTestCases = FolderController.getInstance().getTestCaseChildren(testCase.getParentFolder());
        ArrayList<String> sibblingName = new ArrayList<String>();
        for (TestCaseEntity sibblingTestCase : sibblingTestCases) {
            if (TestCaseController.getDataProviderSetting().getEntityPk((Entity)sibblingTestCase).equals(TestCaseController.getDataProviderSetting().getEntityPk((Entity)testCase))) continue;
            sibblingName.add(sibblingTestCase.getName());
        }
        return sibblingName;
    }

    public TestCaseEntity getTestCaseByDisplayId(String testCaseDisplayId) throws ControllerException {
        try {
            return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getTestCaseByDisplayId(testCaseDisplayId);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public String getGroovyClassName(TestCaseEntity testCase) {
        File testCaseScriptFolder = GroovyUtil.getTestCaseScriptFolder((TestCaseEntity)testCase);
        File[] fileArray = testCaseScriptFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (FilenameUtils.getExtension((String)file.getName()).equals("groovy")) {
                return FilenameUtils.getBaseName((String)file.getName());
            }
            ++n2;
        }
        return GroovyUtil.getGroovyClassName((TestCaseEntity)testCase);
    }

    public String getGroovyScriptFilePath(TestCaseEntity testCase) {
        File testCaseScriptFolder = GroovyUtil.getTestCaseScriptFolder((TestCaseEntity)testCase);
        File[] fileArray = testCaseScriptFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (FilenameUtils.getExtension((String)file.getName()).equals("groovy")) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        return "";
    }

    public VariableEntity getVariable(TestCaseEntity testCase, String variableId) {
        if (testCase == null) {
            throw new IllegalArgumentException(StringConstants.CTRL_EXC_TEST_CASE_CANNOT_BE_NULL);
        }
        if (variableId == null) {
            throw new IllegalArgumentException(StringConstants.CTRL_EXC_VAR_ID_CANNOT_BE_NULL);
        }
        for (VariableEntity variable : testCase.getVariables()) {
            if (!variableId.equals(variable.getId())) continue;
            return variable;
        }
        return null;
    }

    public VariableEntity getVariableById(String testCaseDisplayId, String variableId) {
        TestCaseEntity testCase;
        try {
            testCase = this.getTestCaseByDisplayId(testCaseDisplayId);
        }
        catch (ControllerException controllerException) {
            throw new IllegalArgumentException(StringConstants.CTRL_EXC_VAR_ID_CANNOT_BE_NULL);
        }
        for (VariableEntity variable : testCase.getVariables()) {
            if (!variableId.equals(variable.getId())) continue;
            return variable;
        }
        return null;
    }

    public VariableEntity getVariable(String testCaseDisplayId, String variableName) throws Exception {
        TestCaseEntity testCase = this.getTestCaseByDisplayId(testCaseDisplayId);
        for (VariableEntity variable : testCase.getVariables()) {
            if (!variable.getName().equals(variableName)) continue;
            return variable;
        }
        return null;
    }

    public String getAvailableTestCaseName(FolderEntity parentFolder, String name) throws ControllerException {
        try {
            return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getAvailableTestCaseName(parentFolder, name);
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public TestCaseEntity getTestCaseByScriptName(String scriptFileName) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getTestCaseByScriptFileName(scriptFileName);
    }

    public TestCaseEntity getTestCaseByScriptFilePath(String scriptFilePath) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getTestCaseByScriptFilePath(scriptFilePath);
    }

    public List<TestSuiteEntity> getTestCaseReferences(TestCaseEntity testCase) {
        try {
            return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getTestCaseReferences(testCase);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public void reloadTestCase(TestCaseEntity testCase, Entity entity) throws Exception {
        testCase = this.getTestCase(entity.getId());
        entity = testCase;
    }

    public void loadAllDescentdantEntities(TestCaseEntity testCase) throws Exception {
        GroovyUtil.loadScriptContentIntoTestCase((TestCaseEntity)testCase);
    }

    public TestCaseTestDataLink getTestDataLink(String testDataLinkId, TestCaseEntity testCaseEntity) {
        for (TestCaseTestDataLink dataLink : testCaseEntity.getTestDataLinks()) {
            if (!dataLink.getId().equals(testDataLinkId)) continue;
            return dataLink;
        }
        return null;
    }

    public VariableLink getVariableLink(String testCaseId, String variableName) throws ControllerException {
        TestCaseEntity testCase = this.getTestCaseByDisplayId(testCaseId);
        String id = "";
        for (VariableEntity variable : testCase.getVariables()) {
            if (!variable.getName().equals(variableName)) continue;
            id = variable.getId();
        }
        for (VariableLink variableLink : testCase.getVariableLinks()) {
            if (!variableLink.getVariableId().equals(id)) continue;
            return variableLink;
        }
        return null;
    }

    public boolean isNotUsingDataBinding(TestCaseEntity testEntity) {
        for (VariableLink variableLink : testEntity.getVariableLinks()) {
            if (variableLink.getType() == VariableLink.VariableType.DEFAULT) continue;
            return false;
        }
        return true;
    }

    public List<TestCaseTestDataLink> getTestDataLinkUsedInTestCase(TestCaseEntity testCase) {
        ArrayList<TestCaseTestDataLink> testDataLinkUsed = new ArrayList<TestCaseTestDataLink>();
        HashMap<String, TestCaseTestDataLink> testDataLinkMap = new HashMap<String, TestCaseTestDataLink>();
        for (TestCaseTestDataLink testDataLink : testCase.getTestDataLinks()) {
            testDataLinkMap.put(testDataLink.getId(), testDataLink);
        }
        for (VariableLink variableLink : testCase.getVariableLinks()) {
            String testDataLinkId;
            TestCaseTestDataLink testDataLink;
            if (variableLink.getType() == VariableLink.VariableType.DEFAULT || variableLink.getTestDataLinkId() == null || variableLink.getValue() == null || (testDataLink = (TestCaseTestDataLink)testDataLinkMap.get(testDataLinkId = variableLink.getTestDataLinkId())) == null || testDataLinkUsed.contains(testDataLink)) continue;
            testDataLinkUsed.add(testDataLink);
        }
        return testDataLinkUsed;
    }

    public List<TestCaseEntity> getAllTestCases(ProjectEntity project) throws Exception {
        return TestCaseController.getDataProviderSetting().getTestCaseDataProvider().getAll(project);
    }
}

