/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.cfr.decompiler;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.state.ClassFileSourceImpl;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollectingDumper;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.CannotLoadClassException;
import org.benf.cfr.reader.util.getopt.GetOptParser;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.MethodErrorCollector;
import org.benf.cfr.reader.util.output.StringStreamDumper;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompiler;
import org.sf.feeling.decompiler.util.CommentUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class CfrDecompiler
extends BaseDecompiler {
    private String source = "";
    private long time;
    private String log = "";

    public void decompile(String root, String packege, String className) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.log = "";
        this.source = "";
        File workingDir = new File(String.valueOf(root) + "/" + packege);
        String classPathStr = new File(workingDir, className).getAbsolutePath();
        GetOptParser getOptParser = new GetOptParser();
        try {
            Pair<List<String>, Options> options = getOptParser.parse(new String[]{classPathStr}, OptionsImpl.getFactory());
            Options namedOptions = options.getSecond();
            ClassFileSourceImpl classFileSource = new ClassFileSourceImpl(namedOptions);
            classFileSource.informAnalysisRelativePathDetail(null, null);
            DCCommonState dcCommonState = new DCCommonState(namedOptions, classFileSource);
            IllegalIdentifierDump illegalIdentifierDump = IllegalIdentifierDump.Factory.get(namedOptions);
            ClassFile classFile = dcCommonState.getClassFileMaybePath(classPathStr);
            dcCommonState.configureWith(classFile);
            try {
                classFile = dcCommonState.getClassFile(classFile.getClassType());
            }
            catch (CannotLoadClassException e) {
                throw new RuntimeException(e);
            }
            if (((Boolean)namedOptions.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
                classFile.loadInnerClasses(dcCommonState);
            }
            TypeUsageCollectingDumper typeUsageCollectingDumper = new TypeUsageCollectingDumper(namedOptions, classFile);
            classFile.analyseTop(dcCommonState, typeUsageCollectingDumper);
            TypeUsageInformation typeUsageInfo = typeUsageCollectingDumper.getRealTypeUsageInformation();
            MethodErrorCollector methodErrorCollector = new MethodErrorCollector(){

                @Override
                public void addSummaryError(Method paramMethod, String msg) {
                    CfrDecompiler cfrDecompiler = CfrDecompiler.this;
                    cfrDecompiler.log = String.valueOf(cfrDecompiler.log) + String.format("\n%s: %s", paramMethod.toString(), msg);
                }
            };
            StringBuilder stringBuilder = new StringBuilder(4096);
            StringStreamDumper dumper = new StringStreamDumper(methodErrorCollector, stringBuilder, typeUsageInfo, namedOptions, illegalIdentifierDump);
            classFile.dump(dumper);
            this.source = UnicodeUtil.decode((String)stringBuilder.toString().trim());
            this.source = CommentUtil.clearComments((String)this.source);
        }
        catch (Exception e) {
            this.exceptions.add(e);
            JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
        }
        this.time = stopWatch.getTime();
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String tempDir = JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd");
        File workingDir = new File(String.valueOf(tempDir) + "/ecd_cfr_" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
                this.time = stopWatch.getTime();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public String getLog() {
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "CFR";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return false;
    }

    public String getDecompilerName() {
        return "CFR";
    }

    public String getDecompilerVersion() {
        return "0.152";
    }
}

