/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.component;

import com.katalon.capability.composer.custom.dialog.CapabilityBuilderDialog;
import com.katalon.capability.composer.custom.dialog.CapabilityBuilderDialogFactory;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.model.CapabilitySetting;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityCellEditor
extends DialogCellEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilityCellEditor.class);

    public CapabilityCellEditor(Composite parent) {
        super(parent);
        this.setValidator(value -> {
            if (value instanceof CapabilitySetting) {
                return null;
            }
            return "Invalid Type";
        });
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        CapabilitySetting capabilitySetting = (CapabilitySetting)this.getValue();
        CapabilityBuilderDialog dialog = null;
        try {
            dialog = CapabilityBuilderDialogFactory.createCapabilityBuilderDialog(cellEditorWindow.getShell(), capabilitySetting.clone());
        }
        catch (UnsupportedDriverTypeException e) {
            LOGGER.error("Cannot create capability builder dialog due to unsupported driver type.", (Throwable)e);
            return this.getValue();
        }
        int result = dialog.open();
        if (result == 0) {
            return dialog.getCapabilityDTO();
        }
        return this.getValue();
    }
}

