/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.dialog;

import com.katalon.capability.composer.common.constant.CapabilityUITextConstant;
import com.katalon.capability.composer.custom.component.BuilderDialogNameColumnLabelProvider;
import com.katalon.capability.composer.custom.component.BuilderDialogValueColumnLabelProvider;
import com.katalon.capability.composer.custom.support.BuilderDialogNameColumnSupport;
import com.katalon.capability.composer.custom.support.BuilderDialogValueColumnSupport;
import com.katalon.capability.constant.DriverPlatform;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.model.CapabilitySetting;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class CustomCapabilityBuilderDialog
extends Dialog {
    private final Map<DriverType, Boolean> availableDriverTypeMap = new LinkedHashMap<DriverType, Boolean>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DriverType.CHROME_DRIVER, true);
            this.put(DriverType.FIREFOX_DRIVER, true);
            this.put(DriverType.EDGE_CHROMIUM_DRIVER, true);
            this.put(DriverType.SAFARI_DRIVER, true);
            this.put(DriverType.HEADLESS_DRIVER, true);
            this.put(DriverType.FIREFOX_HEADLESS_DRIVER, true);
            this.put(DriverType.ANDROID_DRIVER, true);
            this.put(DriverType.IOS_DRIVER, true);
            this.put(DriverType.REMOTE_WEB_DRIVER, true);
            this.put(DriverType.WINDOWS_DRIVER, true);
        }
    };
    private final CustomCapabilitySetting customCapabilitySetting;
    private TableViewer tableViewer;
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperty;
    private Supplier<Map<DriverType, Boolean>> getAvailableDriverTypes = () -> this.availableDriverTypeMap;

    public CustomCapabilityBuilderDialog(Shell parentShell, CustomCapabilitySetting customCapabilitySetting) {
        super(parentShell);
        this.customCapabilitySetting = customCapabilitySetting;
        List supportedDriverTypeList = customCapabilitySetting.getSupportedDriverTypes();
        if (supportedDriverTypeList != null) {
            Set driverPlatformSet = supportedDriverTypeList.stream().map(DriverType::getDriverPlatform).collect(Collectors.toSet());
            for (DriverType driverType : this.availableDriverTypeMap.keySet()) {
                if (!driverPlatformSet.contains(driverType.getDriverPlatform())) continue;
                this.availableDriverTypeMap.put(driverType, false);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Composite formComposite = new Composite(container, 0);
        formComposite.setLayout((Layout)new GridLayout(1, false));
        formComposite.setLayoutData((Object)new GridData(1808));
        Composite toolbarComposite = new Composite(formComposite, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(CapabilityUITextConstant.SETT_TOOLITEM_ADD);
        this.tltmAddProperty.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(CapabilityUITextConstant.SETT_TOOLITEM_DELETE);
        this.tltmRemoveProperty.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmClearProperty = new ToolItem(toolBar, 0);
        this.tltmClearProperty.setText(CapabilityUITextConstant.SETT_TOOLITEM_CLEAR);
        this.tltmClearProperty.setImage(ImageConstants.IMG_16_CLEAR);
        this.addToolItemListeners();
        Composite composite = new Composite(formComposite, 0);
        GridLayout glComposite = new GridLayout(1, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        composite.setLayout((Layout)glComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.addTableColumn(this.tableViewer, tableColumnLayout, "Driver Name", 100, 30, new BuilderDialogNameColumnSupport(this.tableViewer, this.getAvailableDriverTypes, this::markSelectedDriverType, this::markUnselectedDriverType), (CellLabelProvider)new BuilderDialogNameColumnLabelProvider());
        this.addTableColumn(this.tableViewer, tableColumnLayout, "Preferences", 100, 70, new BuilderDialogValueColumnSupport(this.tableViewer), (CellLabelProvider)new BuilderDialogValueColumnLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.customCapabilitySetting.getValues().values());
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.customCapabilitySetting.getName());
    }

    private void addTableColumn(TableViewer parent, TableColumnLayout tableColumnLayout, String headerText, int width, int weight, EditingSupport editingSupport, CellLabelProvider labelProvider) {
        TableViewerColumn tableColumn = new TableViewerColumn(parent, 0);
        tableColumn.getColumn().setWidth(width);
        tableColumn.getColumn().setMoveable(true);
        tableColumn.getColumn().setText(headerText);
        tableColumn.setLabelProvider(labelProvider);
        tableColumn.setEditingSupport(editingSupport);
        tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, tableColumn.getColumn().getWidth()));
    }

    public CustomCapabilitySetting getCustomCapabilityDTO() {
        return this.customCapabilitySetting;
    }

    private void addToolItemListeners() {
        this.tltmAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<DriverType> availableDriverTypes = CustomCapabilityBuilderDialog.this.availableDriverTypeMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
                if (availableDriverTypes.isEmpty()) {
                    return;
                }
                DriverType selectedDriverType = availableDriverTypes.get(0);
                CustomCapabilityBuilderDialog.this.markSelectedDriverType(selectedDriverType);
                CustomCapabilityBuilderDialog.this.customCapabilitySetting.getValues().put(selectedDriverType, new CapabilitySetting(selectedDriverType));
                CustomCapabilityBuilderDialog.this.tableViewer.refresh();
            }
        });
        this.tltmRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomCapabilityBuilderDialog.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object selectedObject : selection.toList()) {
                        if (!(selectedObject instanceof CapabilitySetting)) continue;
                        CapabilitySetting capabilitySetting = (CapabilitySetting)selectedObject;
                        CustomCapabilityBuilderDialog.this.customCapabilitySetting.remove(capabilitySetting.getDriverType());
                        CustomCapabilityBuilderDialog.this.markUnselectedDriverType(capabilitySetting.getDriverType());
                    }
                    CustomCapabilityBuilderDialog.this.tableViewer.refresh();
                }
            }
        });
        this.tltmClearProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCapabilityBuilderDialog.this.customCapabilitySetting.getValues().clear();
                for (Map.Entry<DriverType, Boolean> entry : CustomCapabilityBuilderDialog.this.availableDriverTypeMap.entrySet()) {
                    entry.setValue(true);
                }
                CustomCapabilityBuilderDialog.this.tableViewer.refresh();
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    private void markSelectedDriverType(DriverType driverType) {
        DriverPlatform driverPlatform = driverType.getDriverPlatform();
        for (DriverType type : this.availableDriverTypeMap.keySet()) {
            if (type.getDriverPlatform() != driverPlatform) continue;
            this.availableDriverTypeMap.put(type, false);
        }
    }

    private void markUnselectedDriverType(DriverType driverType) {
        DriverPlatform driverPlatform = driverType.getDriverPlatform();
        for (DriverType type : this.availableDriverTypeMap.keySet()) {
            if (type.getDriverPlatform() != driverPlatform) continue;
            this.availableDriverTypeMap.put(type, true);
        }
    }
}

