/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.webui.component;

import com.katalon.capability.composer.common.component.CapabilityComposite;
import com.katalon.capability.composer.common.component.CapabilityPropertyMapComposite;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.constant.RemoteDriverType;
import com.katalon.capability.model.CapabilitySetting;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RemoteWebDriverCapabilityComposite
extends CapabilityComposite {
    private static final String LBL_REMOTE_SERVER_URL = "Remote server URL";
    private static final String LBL_REMOTE_SERVER_TYPE = "Remote server type";
    private Text txtRemoteServerUrl;
    private String txtRemoteServerUrlValue;
    private Combo cbbRemoteDriverType;
    private String cbbRemoteDriverTypeValue;
    private Combo cbbAppiumDriver;
    private String cbbAppiumDriverValue;
    private GridData gdMobileComposite;
    private GridData gdLblDriverType;
    private static final Map<String, DriverType> APPIUM_DRIVER_MAP = Map.of("Android Driver", DriverType.ANDROID_DRIVER, "iOS Driver", DriverType.IOS_DRIVER);

    public RemoteWebDriverCapabilityComposite(Composite parent, int style, CapabilitySetting capabilitySetting) {
        super(parent, style, capabilitySetting);
    }

    @Override
    protected void createContents() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        Composite remoteUrlComposite = new Composite((Composite)this, 0);
        remoteUrlComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glRemoteComposite = new GridLayout(2, false);
        glRemoteComposite.verticalSpacing = 10;
        glRemoteComposite.horizontalSpacing = 15;
        remoteUrlComposite.setLayout((Layout)glRemoteComposite);
        final Label lblRemoteServerUrl = new Label(remoteUrlComposite, 0);
        GridData gdLblServerUrl = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblRemoteServerUrl.setLayoutData((Object)gdLblServerUrl);
        lblRemoteServerUrl.setText(LBL_REMOTE_SERVER_URL);
        this.txtRemoteServerUrl = new Text(remoteUrlComposite, 2048);
        final GridData gdTxtUrl = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtRemoteServerUrl.setLayoutData((Object)gdTxtUrl);
        gdTxtUrl.widthHint = 250;
        this.txtRemoteServerUrl.setToolTipText(this.txtRemoteServerUrl.getText());
        this.txtRemoteServerUrl.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                gdTxtUrl.widthHint = event.width;
                RemoteWebDriverCapabilityComposite.this.gdLblDriverType.widthHint = lblRemoteServerUrl.getBounds().width;
            }
        });
        this.txtRemoteServerUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteWebDriverCapabilityComposite.this.txtRemoteServerUrl.setToolTipText(RemoteWebDriverCapabilityComposite.this.txtRemoteServerUrl.getText());
                RemoteWebDriverCapabilityComposite.this.txtRemoteServerUrlValue = RemoteWebDriverCapabilityComposite.this.txtRemoteServerUrl.getText();
            }
        });
        Label lblRemoteServerType = new Label(remoteUrlComposite, 0);
        GridData gdLblRemoteServerType = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblRemoteServerType.setLayoutData((Object)gdLblRemoteServerType);
        lblRemoteServerType.setText(LBL_REMOTE_SERVER_TYPE);
        this.cbbRemoteDriverType = new Combo(remoteUrlComposite, 8);
        this.cbbRemoteDriverType.setItems(RemoteDriverType.getDisplayNameArray());
        this.cbbRemoteDriverType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = RemoteWebDriverCapabilityComposite.this.cbbRemoteDriverType.getText();
                RemoteDriverType remoteDriverType = RemoteDriverType.fromDisplayName((String)text);
                RemoteWebDriverCapabilityComposite.this.updateMobileCompositeLayout(remoteDriverType);
                RemoteWebDriverCapabilityComposite.this.cbbRemoteDriverTypeValue = text;
            }
        });
        Composite mobileDriverComposite = new Composite((Composite)this, 0);
        this.gdMobileComposite = new GridData(4, 0x1000000, true, false, 1, 1);
        mobileDriverComposite.setLayoutData((Object)this.gdMobileComposite);
        GridLayout glMobileComposite = new GridLayout(2, false);
        glMobileComposite.verticalSpacing = 10;
        glMobileComposite.horizontalSpacing = 15;
        mobileDriverComposite.setLayout((Layout)glMobileComposite);
        Label lblDriverType = new Label(mobileDriverComposite, 0);
        this.gdLblDriverType = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDriverType.setLayoutData((Object)lblDriverType);
        lblDriverType.setLayoutData((Object)this.gdLblDriverType);
        lblDriverType.setText("Appium driver");
        this.cbbAppiumDriver = new Combo(mobileDriverComposite, 8);
        this.cbbAppiumDriver.setItems((String[])APPIUM_DRIVER_MAP.keySet().toArray(String[]::new));
        this.cbbAppiumDriver.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteWebDriverCapabilityComposite.this.cbbAppiumDriverValue = RemoteWebDriverCapabilityComposite.this.cbbAppiumDriver.getText();
            }
        });
        this.capabilityPropertyMapComposite = new CapabilityPropertyMapComposite(this);
        this.updateUI();
    }

    @Override
    public CapabilitySetting getCapability() {
        Map<String, Object> currentDriverProperties = this.capabilityPropertyMapComposite.getDriverProperties();
        if (StringUtils.isNotBlank((CharSequence)this.txtRemoteServerUrlValue)) {
            currentDriverProperties.put("remoteWebDriverUrl", this.txtRemoteServerUrlValue);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cbbRemoteDriverTypeValue)) {
            RemoteDriverType remoteDriverType = RemoteDriverType.fromDisplayName((String)this.cbbRemoteDriverTypeValue);
            currentDriverProperties.put("remoteWebDriverType", remoteDriverType.getDisplayName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.cbbAppiumDriverValue)) {
            DriverType appiumDriverType = APPIUM_DRIVER_MAP.get(this.cbbAppiumDriverValue);
            currentDriverProperties.put("remoteMobileDriver", appiumDriverType);
        }
        this.capabilitySetting.setValue(currentDriverProperties);
        return this.capabilitySetting;
    }

    @Override
    public void updateUI() {
        String remoteDriverType;
        int remoteDriverTypeIndex;
        String remoteDriverUrl = Optional.ofNullable(this.capabilitySetting.getValue()).map(data -> data.get("remoteWebDriverUrl")).map(Object::toString).orElse("");
        if (StringUtils.isNotBlank((CharSequence)remoteDriverUrl)) {
            this.txtRemoteServerUrl.setText(remoteDriverUrl);
            this.txtRemoteServerUrlValue = this.txtRemoteServerUrl.getText();
        }
        if (-1 < (remoteDriverTypeIndex = this.cbbRemoteDriverType.indexOf(remoteDriverType = Optional.ofNullable(this.capabilitySetting.getValue()).map(data -> data.getOrDefault("remoteWebDriverType", "")).map(Object::toString).orElse("")))) {
            this.cbbRemoteDriverType.select(remoteDriverTypeIndex);
            this.cbbRemoteDriverTypeValue = this.cbbRemoteDriverType.getText();
        }
        String appiumDriverTypeStr = Optional.ofNullable(this.capabilitySetting.getValue()).map(data -> data.getOrDefault("remoteMobileDriver", "")).map(Object::toString).orElse("");
        String selectedKey = APPIUM_DRIVER_MAP.entrySet().stream().filter(item -> ((DriverType)item.getValue()).name().equals(appiumDriverTypeStr)).map(Map.Entry::getKey).findFirst().orElse("");
        int appiumDriverTypeIndex = this.cbbAppiumDriver.indexOf(selectedKey);
        if (-1 < appiumDriverTypeIndex) {
            this.cbbAppiumDriver.select(appiumDriverTypeIndex);
            this.cbbAppiumDriverValue = this.cbbAppiumDriver.getText();
        }
        this.capabilitySetting.getValue().remove("remoteWebDriverUrl");
        this.capabilitySetting.getValue().remove("remoteWebDriverType");
        this.capabilitySetting.getValue().remove("remoteMobileDriver");
        super.updateUI();
    }

    private void updateMobileCompositeLayout(RemoteDriverType remoteDriverType) {
        this.gdMobileComposite.heightHint = remoteDriverType != RemoteDriverType.APPIUM ? 0 : -1;
        this.getParent().getParent().layout(true, true);
    }
}

