/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScrollableComposite
extends ScrolledComposite
implements MouseWheelListener {
    private static final int PAGE_INCREMENT = 4;

    public ScrollableComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setContent(Control content) {
        this.removeMouseScrollListenerForCurrentContent();
        super.setContent(content);
    }

    private void removeMouseScrollListenerForCurrentContent() {
        Control oldContent = this.getContent();
        if (oldContent == null || oldContent.isDisposed()) {
            return;
        }
        oldContent.removeMouseWheelListener((MouseWheelListener)this);
    }

    public void mouseScrolled(MouseEvent event) {
        int wheelCount = event.count;
        wheelCount = (int)Math.ceil((float)wheelCount / 3.0f);
        while (wheelCount < 0) {
            this.getVerticalBar().setIncrement(4);
            ++wheelCount;
        }
        while (wheelCount > 0) {
            this.getVerticalBar().setIncrement(-4);
            --wheelCount;
        }
    }

    public void dispose() {
        this.removeMouseScrollListenerForCurrentContent();
        super.dispose();
    }
}

