/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors;

import com.kms.katalon.composer.components.dialogs.AbstractDialogCellEditor;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestDataCellEditor
extends AbstractDialogCellEditor {
    private String defaultContent;
    private String selectedTestDataId;

    public TestDataCellEditor(Composite parent, String defaultContent, String selectedPk) {
        super(parent, defaultContent);
        this.defaultContent = defaultContent;
        this.selectedTestDataId = selectedPk;
    }

    protected void updateContents(Object value) {
        if (value instanceof DataFileEntity) {
            try {
                this.getDefaultLabel().setText(((DataFileEntity)value).getIdForDisplay());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        } else if (this.defaultContent != null) {
            super.updateContents((Object)this.defaultContent);
        } else {
            super.updateContents(value);
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        try {
            EntityProvider entityProvider = new EntityProvider();
            TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(Display.getCurrent().getActiveShell(), new EntityLabelProvider(), new EntityProvider(), new EntityViewerFilter(entityProvider));
            dialog.setAllowMultiple(false);
            dialog.setTitle(StringConstants.EDI_TITLE_TEST_DATA_BROWSER);
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (currentProject != null) {
                DataFileEntity selectedTestData;
                FolderEntity rootFolder = FolderController.getInstance().getTestDataRoot(currentProject);
                dialog.setInput(TreeEntityUtil.getChildren(null, rootFolder));
                if (this.selectedTestDataId != null && (selectedTestData = TestDataController.getInstance().getTestDataByDisplayId(this.selectedTestDataId)) != null) {
                    dialog.setInitialSelection(new TestDataTreeEntity(selectedTestData, (ITreeEntity)TreeEntityUtil.createSelectedTreeEntityHierachy(selectedTestData.getParentFolder(), rootFolder)));
                }
            }
            if (dialog.open() == 0) {
                return dialog.getFirstResult();
            }
            return null;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)StringConstants.EDI_ERROR_MSG_CANNOT_OPEN_DIA);
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

