/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.codemining;

import io.cucumber.eclipse.editor.SWTUtil;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.plugins.MatchedHookStep;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import io.cucumber.eclipse.java.steps.JavaStepDefinitionOpener;
import io.cucumber.eclipse.java.validation.CucumberGlueValidator;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.TestStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JavaReferencesCodeMiningProvider
implements ICodeMiningProvider {
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                CucumberJavaPreferences preferences;
                IDocument document = viewer.getDocument();
                IJavaProject javaProject = JDTUtil.getJavaProject(document);
                if (javaProject != null && (preferences = CucumberJavaPreferences.of((IResource)javaProject.getProject())).showHooks()) {
                    Collection<MatchedStep<?>> steps = CucumberGlueValidator.getMatchedSteps(document, monitor);
                    ArrayList list = new ArrayList();
                    Map<Integer, List<MatchedHookStep>> stepByLine = steps.stream().filter(MatchedHookStep.class::isInstance).map(MatchedHookStep.class::cast).collect(Collectors.groupingBy(step -> step.getLocation().getLine()));
                    for (Map.Entry<Integer, List<MatchedHookStep>> entry : stepByLine.entrySet()) {
                        int lineNumber = entry.getKey() - 1;
                        Map<HookType, List<MatchedHookStep>> hooksByType = entry.getValue().stream().collect(Collectors.groupingBy(hookStep -> ((HookTestStep)hookStep.getTestStep()).getHookType()));
                        hooksByType.entrySet().stream().sorted((e1, e2) -> ((HookType)e1.getKey()).ordinal() - ((HookType)e2.getKey()).ordinal()).map(e -> {
                            try {
                                return new HooksCodeMining(lineNumber, document, this, (HookType)e.getKey(), (List)e.getValue(), javaProject);
                            }
                            catch (BadLocationException e3) {
                                return null;
                            }
                        }).filter(Objects::nonNull).forEach(list::add);
                    }
                    return list;
                }
            }
            catch (OperationCanceledException document) {
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
            }
            catch (CoreException e4) {
                e4.printStackTrace();
            }
            return Collections.emptyList();
        });
    }

    public void dispose() {
    }

    private static final Position createPosition(Location location, IDocument document) throws BadLocationException {
        int line = location.getLine();
        int offset = document.getLineOffset(line - 1);
        int lineLength = document.getLineLength(line - 1);
        return new Position(offset + lineLength - 1, 1);
    }

    private static final class HooksCodeMining
    extends LineHeaderCodeMining {
        private HookType hookType;
        private List<MatchedHookStep> list;
        private AtomicReference<Consumer<MouseEvent>> action = new AtomicReference();
        private IJavaProject javaProject;

        public HooksCodeMining(int beforeLineNumber, IDocument document, ICodeMiningProvider provider, HookType hookType, List<MatchedHookStep> list, IJavaProject javaProject) throws BadLocationException {
            super(beforeLineNumber, document, provider);
            this.hookType = hookType;
            this.list = list;
            this.javaProject = javaProject;
        }

        protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
            return CompletableFuture.supplyAsync(() -> {
                String hookName = switch (this.hookType) {
                    case HookType.BEFORE -> "@Before";
                    case HookType.AFTER -> "@After";
                    case HookType.AFTER_STEP -> "@AfterStep";
                    case HookType.BEFORE_STEP -> "@BeforeStep";
                    default -> this.hookType.toString();
                };
                int size = this.list.size();
                this.setLabel(hookName + ": " + size);
                Set resolvedMethods = this.list.stream().collect(Collectors.toMap(Function.identity(), step -> {
                    try {
                        return JDTUtil.resolveMethod(this.javaProject, step.getCodeLocation(), null);
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                })).entrySet();
                this.action.set(event -> {
                    Shell shell = SWTUtil.getShell((TypedEvent)event);
                    if (resolvedMethods.size() == 1) {
                        Map.Entry entry = (Map.Entry)resolvedMethods.iterator().next();
                        this.open((MatchedHookStep)entry.getKey(), (IMethod[])entry.getValue(), shell);
                    } else {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

                            public String getText(Object element) {
                                if (element instanceof Map.Entry) {
                                    Object key;
                                    Map.Entry entry = (Map.Entry)element;
                                    Object value = entry.getValue();
                                    if (value instanceof IMethod) {
                                        try {
                                            return JDTUtil.getMethodName((IMethod)value);
                                        }
                                        catch (JavaModelException javaModelException) {
                                            // empty catch block
                                        }
                                    }
                                    if ((key = entry.getKey()) instanceof MatchedHookStep) {
                                        MatchedHookStep step = (MatchedHookStep)key;
                                        return step.getCodeLocation().toString();
                                    }
                                }
                                return element.toString();
                            }
                        });
                        dialog.setElements(resolvedMethods.toArray());
                        if (dialog.open() == 0) {
                            Object[] objectArray = dialog.getResult();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object e = objectArray[n2];
                                Map.Entry entry = (Map.Entry)e;
                                this.open((MatchedHookStep)entry.getKey(), (IMethod[])entry.getValue(), shell);
                                ++n2;
                            }
                        }
                    }
                });
                return null;
            });
        }

        private void open(MatchedHookStep step, IMethod[] method, Shell shell) {
            if (method != null && method.length > 0) {
                JavaStepDefinitionOpener.showMethod(method, shell);
                return;
            }
            MessageDialog.openInformation((Shell)shell, (String)"Method not found", (String)("Location " + String.valueOf(step.getCodeLocation()) + " not found"));
        }

        public Consumer<MouseEvent> getAction() {
            return this.action.get();
        }
    }

    private static final class JavaReferenceCodeMining
    extends LineContentCodeMining {
        private TestStep testStep;

        public JavaReferenceCodeMining(Position position, ICodeMiningProvider provider, TestStep testStep) {
            super(position, provider);
            this.testStep = testStep;
        }

        protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
            return CompletableFuture.supplyAsync(() -> {
                this.setLabel(this.testStep.getCodeLocation());
                return null;
            });
        }
    }
}

