/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.launching;

import io.cucumber.core.resource.Resource;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;

public class DocumentResource
implements Resource {
    private IDocument document;
    private URI uri;

    public DocumentResource(GherkinEditorDocument document) {
        this.document = document.getDocument();
        IResource resource = document.getResource();
        if (resource != null) {
            this.uri = Objects.requireNonNullElseGet(resource.getLocationURI(), () -> resource.getRawLocationURI());
        } else {
            try {
                this.uri = new URI("document:/" + System.identityHashCode(document));
            }
            catch (URISyntaxException e) {
                throw new AssertionError("should never happen", e);
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.document.get().getBytes(StandardCharsets.UTF_8));
    }
}

