/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.launching;

import io.cucumber.eclipse.editor.launching.EnvelopeListener;
import io.cucumber.eclipse.editor.launching.EnvelopeProvider;
import io.cucumber.eclipse.java.Activator;
import io.cucumber.eclipse.java.plugins.MessageEndpoint;
import io.cucumber.messages.types.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ISuspendResume;

public class MessageEndpointProcess
extends MessageEndpoint
implements IProcess,
EnvelopeProvider,
ISuspendResume,
IDisconnect {
    private ILaunch launch;
    private List<Envelope> envelopes = new ArrayList<Envelope>();
    private List<EnvelopeListener> consumers = new ArrayList<EnvelopeListener>();
    private Map<String, String> attributes = new HashMap<String, String>();
    private volatile boolean suspended;
    private IBreakpoint[] breakpoints;

    public MessageEndpointProcess(ILaunch launch) throws IOException {
        this.launch = launch;
        launch.addProcess((IProcess)this);
        this.attributes.put(IProcess.ATTR_PROCESS_TYPE, "cucumber-message-endpoint");
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean canTerminate() {
        return false;
    }

    public String getLabel() {
        return "Cucumber Message Listener";
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(Envelope envelope) throws InterruptedException {
        MessageEndpointProcess messageEndpointProcess = this;
        synchronized (messageEndpointProcess) {
            while (this.suspended) {
                ((Object)((Object)this)).wait();
            }
            this.envelopes.add(envelope);
            for (EnvelopeListener consumer : this.consumers) {
                try {
                    consumer.handleEnvelope(envelope);
                }
                catch (RuntimeException e) {
                    Activator.getDefault().getLog().error("Listener throws RuntimeException while handling Envelope " + String.valueOf(envelope), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvelopeListener(EnvelopeListener listener) {
        MessageEndpointProcess messageEndpointProcess = this;
        synchronized (messageEndpointProcess) {
            if (!this.consumers.contains(listener)) {
                this.consumers.add(listener);
                for (Envelope envelope : this.envelopes) {
                    listener.handleEnvelope(envelope);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeEnvelopeListener(EnvelopeListener listener) {
        MessageEndpointProcess messageEndpointProcess = this;
        synchronized (messageEndpointProcess) {
            this.consumers.remove(listener);
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        this.suspended = false;
        MessageEndpointProcess messageEndpointProcess = this;
        synchronized (messageEndpointProcess) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void suspend() throws DebugException {
        this.suspended = true;
    }
}

