/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.plugins;

import io.cucumber.eclipse.java.plugins.MatchedHookStep;
import io.cucumber.eclipse.java.plugins.MatchedPickleStep;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class CucumberMatchedStepsPlugin
implements Plugin,
ConcurrentEventListener,
EventListener {
    private Collection<MatchedStep<?>> matchedSteps = ConcurrentHashMap.newKeySet();

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        TestStep testStep = event.getTestStep();
        if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            if (pickleStepTestStep.getCodeLocation() != null) {
                this.matchedSteps.add(new MatchedPickleStep(pickleStepTestStep));
            }
        } else if (testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)testStep;
            this.matchedSteps.add(new MatchedHookStep(hookTestStep, event.getTestCase().getLocation()));
        }
    }

    public Collection<MatchedStep<?>> getMatchedSteps() {
        return this.matchedSteps;
    }
}

