/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.plugins;

import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CucumberMissingStepsPlugin
implements Plugin,
ConcurrentEventListener,
EventListener {
    private Map<Integer, Collection<String>> snippets = new ConcurrentHashMap<Integer, Collection<String>>();

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(SnippetsSuggestedEvent.class, this::handleSnippetsSuggestedEvent);
    }

    private void handleSnippetsSuggestedEvent(SnippetsSuggestedEvent event) {
        Location stepLocation = event.getStepLocation();
        this.snippets.computeIfAbsent(stepLocation.getLine(), l -> ConcurrentHashMap.newKeySet()).addAll(event.getSnippets());
    }

    public Map<Integer, Collection<String>> getSnippets() {
        return this.snippets;
    }
}

