/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.plugins;

import io.cucumber.eclipse.java.plugins.CucumberCodeLocation;
import io.cucumber.eclipse.java.plugins.CucumberStepDefinition;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.StepDefinedEvent;
import io.cucumber.plugin.event.StepDefinition;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CucumberStepParserPlugin
implements Plugin,
ConcurrentEventListener,
EventListener {
    private Map<CucumberCodeLocation, CucumberStepDefinition> stepList = new ConcurrentHashMap<CucumberCodeLocation, CucumberStepDefinition>();

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(StepDefinedEvent.class, this::handleStepDefinedEvent);
    }

    private void handleStepDefinedEvent(StepDefinedEvent event) {
        StepDefinition definition = event.getStepDefinition();
        this.stepList.computeIfAbsent(new CucumberCodeLocation(definition.getLocation()), location -> new CucumberStepDefinition(definition, (CucumberCodeLocation)location));
    }

    public Collection<CucumberStepDefinition> getStepList() {
        return this.stepList.values();
    }
}

