/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.quickfix;

import io.cucumber.eclipse.editor.Images;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.java.Activator;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.quickfix.SnippetApplicator;
import io.cucumber.eclipse.java.validation.CucumberGlueValidator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class StepCreationMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            GherkinEditorDocument editorDocument;
            IResource resource;
            IJavaProject project;
            boolean isUnmatchedStepMarker = "cucumber.eclipse.marker.gherkin.unmatched_step".equals(marker.getType());
            if (!isUnmatchedStepMarker) {
                return new IMarkerResolution[0];
            }
            if (this.hasResolutions(marker) && (project = JDTUtil.getJavaProject(resource = marker.getResource())) != null && (editorDocument = GherkinEditorDocument.get((IResource)resource)) != null) {
                Collection<ICompilationUnit> glueSources = JDTUtil.getGlueSources(project, null);
                return (IMarkerResolution[])glueSources.stream().filter(unit -> unit.getResource() instanceof IFile).sorted((c1, c2) -> c1.getElementName().compareToIgnoreCase(c2.getElementName())).map(unit -> new StepCreationMarkerResolution((ICompilationUnit)unit, editorDocument)).toArray(IMarkerResolution[]::new);
            }
            return new IMarkerResolution[0];
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new IMarkerResolution[0];
        }
    }

    public boolean hasResolutions(IMarker marker) {
        String snippet = marker.getAttribute("cucumber.eclipse.marker.gherkin.unmatched_step.snippet", "");
        return !snippet.isBlank() && "io.cucumber.eclipse.java".equals(marker.getAttribute("cucumber.eclipse.marker.gherkin.unmatched_step.snippet.type", "")) && JDTUtil.isJavaProject(marker.getResource().getProject());
    }

    private static class StepCreationMarkerResolution
    extends WorkbenchMarkerResolution
    implements IMarkerResolution {
        private ICompilationUnit unit;
        private GherkinEditorDocument editorDocument;

        public StepCreationMarkerResolution(ICompilationUnit unit, GherkinEditorDocument editorDocument) {
            this.unit = unit;
            this.editorDocument = editorDocument;
        }

        public void run(IMarker marker) {
            String snippet = marker.getAttribute("cucumber.eclipse.marker.gherkin.unmatched_step.snippet", "");
            this.applySnippet(snippet);
        }

        private void applySnippet(String snippet) {
            try {
                SnippetApplicator.generateSnippet(snippet, (IFile)this.unit.getResource());
                CucumberGlueValidator.revalidate(this.editorDocument.getDocument());
            }
            catch (IOException | CoreException | BadLocationException | MalformedTreeException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.java", String.format("Couldn't generate snippet %s for %s", snippet, this.unit.getResource()), e));
            }
        }

        public void run(IMarker[] markers, IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)markers.length);
            HashSet<String> created = new HashSet<String>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String snippet = marker.getAttribute("cucumber.eclipse.marker.gherkin.unmatched_step.snippet", "");
                if (created.add(snippet)) {
                    this.applySnippet(snippet);
                }
                subMonitor.worked(1);
                ++n2;
            }
        }

        public String getLabel() {
            return String.format("Create step in %s", this.unit.getElementName());
        }

        public String getDescription() {
            return "Create missing step in existing java source file";
        }

        public Image getImage() {
            return Images.getCukesIcon();
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            return (IMarker[])Arrays.stream(markers).filter(marker -> {
                try {
                    return "cucumber.eclipse.marker.gherkin.unmatched_step".equals(marker.getType());
                }
                catch (CoreException e) {
                    return false;
                }
            }).toArray(IMarker[]::new);
        }
    }
}

