/*
 * Decompiled with CFR 0.152.
 */
package graphql.incremental;

import graphql.ExperimentalApi;
import graphql.GraphQLError;
import graphql.execution.ResultPath;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@ExperimentalApi
public abstract class IncrementalPayload {
    private final List<Object> path;
    private final String label;
    private final List<GraphQLError> errors;
    private final transient Map<Object, Object> extensions;

    protected IncrementalPayload(List<Object> path, String label, List<GraphQLError> errors2, Map<Object, Object> extensions) {
        this.path = path;
        this.errors = errors2;
        this.label = label;
        this.extensions = extensions;
    }

    public List<Object> getPath() {
        return this.path;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable List<GraphQLError> getErrors() {
        return this.errors;
    }

    public @Nullable Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    public Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("path", this.path);
        if (this.label != null) {
            result.put("label", this.label);
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            result.put("errors", this.errorsToSpec(this.errors));
        }
        if (this.extensions != null) {
            result.put("extensions", this.extensions);
        }
        return result;
    }

    protected Object errorsToSpec(List<GraphQLError> errors2) {
        List list = FpKit.arrayListSizedTo(errors2);
        for (GraphQLError error : errors2) {
            list.add(error.toSpecification());
        }
        return list;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.label, this.errors, this.extensions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IncrementalPayload that = (IncrementalPayload)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.label, that.label) && Objects.equals(this.errors, that.errors) && Objects.equals(this.extensions, that.extensions);
    }

    protected static abstract class Builder<T extends Builder<T>> {
        protected List<Object> path;
        protected String label;
        protected List<GraphQLError> errors = new ArrayList<GraphQLError>();
        protected Map<Object, Object> extensions;

        protected Builder() {
        }

        public T from(IncrementalPayload incrementalPayload) {
            this.path = incrementalPayload.getPath();
            this.label = incrementalPayload.getLabel();
            if (incrementalPayload.getErrors() != null) {
                this.errors = new ArrayList<GraphQLError>(incrementalPayload.getErrors());
            }
            this.extensions = incrementalPayload.getExtensions();
            return (T)this;
        }

        public T path(ResultPath path) {
            if (path != null) {
                this.path = path.toList();
            }
            return (T)this;
        }

        public T path(List<Object> path) {
            this.path = path;
            return (T)this;
        }

        public T label(String label) {
            this.label = label;
            return (T)this;
        }

        public T errors(List<GraphQLError> errors2) {
            this.errors = errors2;
            return (T)this;
        }

        public T addErrors(List<GraphQLError> errors2) {
            this.errors.addAll(errors2);
            return (T)this;
        }

        public T addError(GraphQLError error) {
            this.errors.add(error);
            return (T)this;
        }

        public T extensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return (T)this;
        }

        public T addExtension(String key, Object value) {
            this.extensions = this.extensions == null ? new LinkedHashMap() : this.extensions;
            this.extensions.put(key, value);
            return (T)this;
        }
    }
}

