/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.language.AbstractDescribedNode;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.util.EscapeUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class AstPrinter {
    private final Map<Class<? extends Node>, NodePrinter<? extends Node>> printers = new LinkedHashMap<Class<? extends Node>, NodePrinter<? extends Node>>();
    private final boolean compactMode;

    AstPrinter(boolean compactMode) {
        this.compactMode = compactMode;
        this.printers.put(Argument.class, this.argument());
        this.printers.put(ArrayValue.class, this.value());
        this.printers.put(BooleanValue.class, this.value());
        this.printers.put(NullValue.class, this.value());
        this.printers.put(Directive.class, this.directive());
        this.printers.put(DirectiveDefinition.class, this.directiveDefinition());
        this.printers.put(DirectiveLocation.class, this.directiveLocation());
        this.printers.put(Document.class, this.document());
        this.printers.put(EnumTypeDefinition.class, this.enumTypeDefinition());
        this.printers.put(EnumTypeExtensionDefinition.class, this.enumTypeExtensionDefinition());
        this.printers.put(EnumValue.class, this.enumValue());
        this.printers.put(EnumValueDefinition.class, this.enumValueDefinition());
        this.printers.put(Field.class, this.field());
        this.printers.put(FieldDefinition.class, this.fieldDefinition());
        this.printers.put(FloatValue.class, this.value());
        this.printers.put(FragmentDefinition.class, this.fragmentDefinition());
        this.printers.put(FragmentSpread.class, this.fragmentSpread());
        this.printers.put(InlineFragment.class, this.inlineFragment());
        this.printers.put(InputObjectTypeDefinition.class, this.inputObjectTypeDefinition());
        this.printers.put(InputObjectTypeExtensionDefinition.class, this.inputObjectTypeExtensionDefinition());
        this.printers.put(InputValueDefinition.class, this.inputValueDefinition());
        this.printers.put(InterfaceTypeDefinition.class, this.interfaceTypeDefinition());
        this.printers.put(InterfaceTypeExtensionDefinition.class, this.interfaceTypeExtensionDefinition());
        this.printers.put(IntValue.class, this.value());
        this.printers.put(ListType.class, this.type());
        this.printers.put(NonNullType.class, this.type());
        this.printers.put(ObjectField.class, this.objectField());
        this.printers.put(ObjectTypeDefinition.class, this.objectTypeDefinition());
        this.printers.put(ObjectTypeExtensionDefinition.class, this.objectTypeExtensionDefinition());
        this.printers.put(ObjectValue.class, this.value());
        this.printers.put(OperationDefinition.class, this.operationDefinition());
        this.printers.put(OperationTypeDefinition.class, this.operationTypeDefinition());
        this.printers.put(ScalarTypeDefinition.class, this.scalarTypeDefinition());
        this.printers.put(ScalarTypeExtensionDefinition.class, this.scalarTypeExtensionDefinition());
        this.printers.put(SchemaDefinition.class, this.schemaDefinition());
        this.printers.put(SchemaExtensionDefinition.class, this.schemaExtensionDefinition());
        this.printers.put(SelectionSet.class, this.selectionSet());
        this.printers.put(StringValue.class, this.value());
        this.printers.put(TypeName.class, this.type());
        this.printers.put(UnionTypeDefinition.class, this.unionTypeDefinition());
        this.printers.put(UnionTypeExtensionDefinition.class, this.unionTypeExtensionDefinition());
        this.printers.put(VariableDefinition.class, this.variableDefinition());
        this.printers.put(VariableReference.class, this.variableReference());
    }

    private NodePrinter<Argument> argument() {
        if (this.compactMode) {
            return (out, node) -> {
                out.append(node.getName()).append(':');
                this.value(out, node.getValue());
            };
        }
        return (out, node) -> {
            out.append(node.getName()).append(": ");
            this.value(out, node.getValue());
        };
    }

    private NodePrinter<Document> document() {
        if (this.compactMode) {
            return (out, node) -> this.join(out, node.getDefinitions(), " ");
        }
        return (out, node) -> {
            this.join(out, node.getDefinitions(), "\n\n");
            out.append('\n');
        };
    }

    private NodePrinter<Directive> directive() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            out.append('@');
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getArguments())) {
                out.append('(');
                this.join(out, node.getArguments(), argSep);
                out.append(')');
            }
        };
    }

    private NodePrinter<DirectiveDefinition> directiveDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            this.description(out, node);
            out.append("directive @");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getInputValueDefinitions())) {
                out.append('(');
                this.join(out, node.getInputValueDefinitions(), argSep);
                out.append(')');
            }
            out.append(" ");
            if (node.isRepeatable()) {
                out.append("repeatable ");
            }
            out.append("on ");
            this.join(out, node.getDirectiveLocations(), " | ");
        };
    }

    private NodePrinter<DirectiveLocation> directiveLocation() {
        return (out, node) -> out.append(node.getName());
    }

    private NodePrinter<EnumTypeDefinition> enumTypeDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append("enum ");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
            out.append(' ');
            this.block(out, node.getEnumValueDefinitions());
        };
    }

    private NodePrinter<EnumValue> enumValue() {
        return (out, node) -> out.append(node.getName());
    }

    private NodePrinter<EnumValueDefinition> enumValueDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
        };
    }

    private NodePrinter<Field> field() {
        String argSep = this.compactMode ? "," : ", ";
        String aliasSuffix = this.compactMode ? ":" : ": ";
        return (out, node) -> {
            String name = node.getName();
            if (!AstPrinter.isEmpty(node.getAlias())) {
                out.append(node.getAlias());
                out.append(aliasSuffix);
            }
            out.append(name);
            if (!AstPrinter.isEmpty(node.getArguments())) {
                out.append('(');
                this.join(out, node.getArguments(), argSep);
                out.append(')');
            }
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
            if (node.getSelectionSet() != null && !AstPrinter.isEmpty(node.getSelectionSet().getSelections())) {
                if (!this.compactMode) {
                    out.append(' ');
                }
                this.node(out, node.getSelectionSet());
            }
        };
    }

    private NodePrinter<FieldDefinition> fieldDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            if (AstPrinter.hasDescription(node) && !this.compactMode) {
                this.description(out, node);
                out.append(node.getName());
                if (!AstPrinter.isEmpty(node.getInputValueDefinitions())) {
                    out.append("(\n");
                    this.join(out, node.getInputValueDefinitions(), "\n");
                    out.append(')');
                }
                out.append(": ");
                this.type(out, node.getType());
                if (!AstPrinter.isEmpty(node.getDirectives())) {
                    out.append(' ');
                    this.directives(out, node.getDirectives());
                }
            } else {
                out.append(node.getName());
                if (!AstPrinter.isEmpty(node.getInputValueDefinitions())) {
                    out.append('(');
                    this.join(out, node.getInputValueDefinitions(), argSep);
                    out.append(')');
                }
                out.append(": ");
                this.type(out, node.getType());
                if (!AstPrinter.isEmpty(node.getDirectives())) {
                    out.append(' ');
                    this.directives(out, node.getDirectives());
                }
            }
        };
    }

    private static boolean hasDescription(Node<?> node) {
        if (node instanceof AbstractDescribedNode) {
            AbstractDescribedNode describedNode = (AbstractDescribedNode)node;
            return describedNode.getDescription() != null;
        }
        return false;
    }

    private NodePrinter<FragmentDefinition> fragmentDefinition() {
        return (out, node) -> {
            out.append("fragment ");
            out.append(node.getName());
            out.append(" on ");
            this.type(out, node.getTypeCondition());
            out.append(' ');
            this.directives(out, node.getDirectives());
            this.node(out, node.getSelectionSet());
        };
    }

    private NodePrinter<FragmentSpread> fragmentSpread() {
        return (out, node) -> {
            out.append("...");
            out.append(node.getName());
            this.directives(out, node.getDirectives());
        };
    }

    private NodePrinter<InlineFragment> inlineFragment() {
        return (out, node) -> {
            out.append("...");
            if (this.compactMode) {
                if (node.getTypeCondition() != null) {
                    out.append("on ");
                    this.type(out, node.getTypeCondition());
                }
                this.directives(out, node.getDirectives());
                this.node(out, node.getSelectionSet());
            } else {
                if (node.getTypeCondition() != null) {
                    out.append(" on ");
                    this.type(out, node.getTypeCondition());
                }
                if (!AstPrinter.isEmpty(node.getDirectives())) {
                    out.append(' ');
                    this.directives(out, node.getDirectives());
                }
                out.append(' ');
                this.node(out, node.getSelectionSet());
            }
        };
    }

    private NodePrinter<InputObjectTypeDefinition> inputObjectTypeDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append("input ");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
            if (!AstPrinter.isEmpty(node.getInputValueDefinitions())) {
                out.append(' ');
                this.block(out, node.getInputValueDefinitions());
            }
        };
    }

    private NodePrinter<InputValueDefinition> inputValueDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        String defaultValueEquals = this.compactMode ? "=" : "= ";
        return (out, node) -> {
            Value defaultValue = node.getDefaultValue();
            this.description(out, node);
            out.append(node.getName());
            out.append(nameTypeSep);
            this.type(out, node.getType());
            if (defaultValue != null) {
                out.append(' ');
                out.append(defaultValueEquals);
                this.node(out, defaultValue);
            }
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
        };
    }

    private NodePrinter<InterfaceTypeDefinition> interfaceTypeDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append("interface ");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getImplements())) {
                out.append(" implements ");
                this.join(out, node.getImplements(), " & ");
            }
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
            if (!AstPrinter.isEmpty(node.getFieldDefinitions())) {
                out.append(' ');
                this.block(out, node.getFieldDefinitions());
            }
        };
    }

    private NodePrinter<ObjectField> objectField() {
        String nameValueSep = this.compactMode ? ":" : " : ";
        return (out, node) -> {
            out.append(node.getName());
            out.append(nameValueSep);
            this.value(out, node.getValue());
        };
    }

    private NodePrinter<OperationDefinition> operationDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            String name = node.getName();
            if (AstPrinter.isEmpty(name) && AstPrinter.isEmpty(node.getDirectives()) && AstPrinter.isEmpty(node.getVariableDefinitions()) && node.getOperation() == OperationDefinition.Operation.QUERY) {
                this.node(out, node.getSelectionSet());
            } else {
                out.append(node.getOperation().toString().toLowerCase());
                if (!AstPrinter.isEmpty(name)) {
                    out.append(' ');
                    out.append(name);
                }
                if (!AstPrinter.isEmpty(node.getVariableDefinitions())) {
                    if (AstPrinter.isEmpty(name)) {
                        out.append(' ');
                    }
                    out.append('(');
                    this.join(out, node.getVariableDefinitions(), argSep);
                    out.append(')');
                }
                if (!AstPrinter.isEmpty(node.getDirectives())) {
                    out.append(' ');
                    this.directives(out, node.getDirectives());
                }
                if (!this.compactMode) {
                    out.append(' ');
                }
                this.node(out, node.getSelectionSet());
            }
        };
    }

    private NodePrinter<OperationTypeDefinition> operationTypeDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        return (out, node) -> {
            out.append(node.getName());
            out.append(nameTypeSep);
            this.type(out, node.getTypeName());
        };
    }

    private NodePrinter<ObjectTypeDefinition> objectTypeDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append("type ");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getImplements())) {
                out.append(" implements ");
                this.join(out, node.getImplements(), " & ");
            }
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
            if (!AstPrinter.isEmpty(node.getFieldDefinitions())) {
                out.append(' ');
                this.block(out, node.getFieldDefinitions());
            }
        };
    }

    private NodePrinter<SelectionSet> selectionSet() {
        return (out, node) -> this.block(out, node.getSelections());
    }

    private NodePrinter<ScalarTypeDefinition> scalarTypeDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append("scalar ");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
        };
    }

    private NodePrinter<SchemaDefinition> schemaDefinition() {
        return (out, node) -> {
            this.description(out, node);
            out.append("schema ");
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                this.directives(out, node.getDirectives());
                out.append(' ');
            }
            this.block(out, node.getOperationTypeDefinitions());
        };
    }

    private NodePrinter<Type<?>> type() {
        return this::type;
    }

    private void type(StringBuilder out, Type<?> type) {
        if (type instanceof NonNullType) {
            NonNullType inner = (NonNullType)type;
            this.type(out, inner.getType());
            out.append('!');
        } else if (type instanceof ListType) {
            ListType inner = (ListType)type;
            out.append('[');
            this.type(out, inner.getType());
            out.append(']');
        } else {
            TypeName inner = (TypeName)type;
            out.append(inner.getName());
        }
    }

    private NodePrinter<ObjectTypeExtensionDefinition> objectTypeExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, ObjectTypeDefinition.class);
        };
    }

    private NodePrinter<EnumTypeExtensionDefinition> enumTypeExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, EnumTypeDefinition.class);
        };
    }

    private NodePrinter<InterfaceTypeDefinition> interfaceTypeExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, InterfaceTypeDefinition.class);
        };
    }

    private NodePrinter<UnionTypeExtensionDefinition> unionTypeExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, UnionTypeDefinition.class);
        };
    }

    private NodePrinter<ScalarTypeExtensionDefinition> scalarTypeExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, ScalarTypeDefinition.class);
        };
    }

    private NodePrinter<InputObjectTypeExtensionDefinition> inputObjectTypeExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, InputObjectTypeDefinition.class);
        };
    }

    private NodePrinter<SchemaExtensionDefinition> schemaExtensionDefinition() {
        return (out, node) -> {
            out.append("extend ");
            this.node(out, node, SchemaDefinition.class);
        };
    }

    private NodePrinter<UnionTypeDefinition> unionTypeDefinition() {
        String barSep = this.compactMode ? "|" : " | ";
        String equals = this.compactMode ? "=" : "= ";
        return (out, node) -> {
            this.description(out, node);
            out.append("union ");
            out.append(node.getName());
            if (!AstPrinter.isEmpty(node.getDirectives())) {
                out.append(' ');
                this.directives(out, node.getDirectives());
            }
            out.append(' ');
            out.append(equals);
            this.join(out, node.getMemberTypes(), barSep);
        };
    }

    private NodePrinter<VariableDefinition> variableDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        String defaultValueEquals = this.compactMode ? "=" : " = ";
        return (out, node) -> {
            out.append('$');
            out.append(node.getName());
            out.append(nameTypeSep);
            this.type(out, node.getType());
            if (node.getDefaultValue() != null) {
                out.append(defaultValueEquals);
                this.node(out, node.getDefaultValue());
            }
            this.directives(out, node.getDirectives());
        };
    }

    private NodePrinter<VariableReference> variableReference() {
        return (out, node) -> out.append('$').append(node.getName());
    }

    private String node(Node<?> node) {
        return this.node(node, null);
    }

    private void node(StringBuilder out, Node<?> node) {
        this.node(out, node, null);
    }

    private String node(Node<?> node, Class<?> startClass) {
        StringBuilder builder = new StringBuilder();
        this.node(builder, node, startClass);
        return builder.toString();
    }

    private void node(StringBuilder out, Node<?> node, Class<?> startClass) {
        if (startClass != null) {
            Assert.assertTrue(startClass.isInstance(node), () -> "The starting class must be in the inherit tree");
        }
        NodePrinter<Node<?>> printer = this._findPrinter(node, startClass);
        printer.print(out, node);
    }

    <T extends Node> NodePrinter<T> _findPrinter(Node node) {
        return this._findPrinter(node, null);
    }

    <T extends Node> NodePrinter<T> _findPrinter(Node node, Class startClass) {
        Class<?> clazz;
        if (node == null) {
            return (out, type) -> {};
        }
        Class<?> clazz2 = clazz = startClass != null ? startClass : node.getClass();
        while (clazz != Object.class) {
            NodePrinter<? extends Node> nodePrinter = this.printers.get(clazz);
            if (nodePrinter != null) {
                return nodePrinter;
            }
            clazz = clazz.getSuperclass();
        }
        return (NodePrinter)Assert.assertShouldNeverHappen("We have a missing printer implementation for %s : report a bug!", clazz);
    }

    private static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private static boolean isEmpty(String s2) {
        return s2 == null || s2.isBlank();
    }

    private static <T> List<T> nvl(List<T> list) {
        return list != null ? list : ImmutableKit.emptyList();
    }

    private NodePrinter<Value<?>> value() {
        return this::value;
    }

    private void value(StringBuilder out, Value<?> value) {
        String argSep;
        String string = argSep = this.compactMode ? "," : ", ";
        if (value instanceof IntValue) {
            out.append(((IntValue)value).getValue());
        } else if (value instanceof FloatValue) {
            out.append(((FloatValue)value).getValue());
        } else if (value instanceof StringValue) {
            out.append('\"');
            EscapeUtil.escapeJsonStringTo(out, ((StringValue)value).getValue());
            out.append('\"');
        } else if (value instanceof EnumValue) {
            out.append(((EnumValue)value).getName());
        } else if (value instanceof BooleanValue) {
            out.append(((BooleanValue)value).isValue());
        } else if (value instanceof NullValue) {
            out.append("null");
        } else if (value instanceof ArrayValue) {
            out.append('[');
            this.join(out, ((ArrayValue)value).getValues(), argSep);
            out.append(']');
        } else if (value instanceof ObjectValue) {
            out.append('{');
            this.join(out, ((ObjectValue)value).getObjectFields(), argSep);
            out.append('}');
        } else if (value instanceof VariableReference) {
            out.append('$');
            out.append(((VariableReference)value).getName());
        }
    }

    private void description(StringBuilder out, Node<?> node) {
        Description description = ((AbstractDescribedNode)node).getDescription();
        if (description == null || description.getContent() == null || this.compactMode) {
            return;
        }
        if (description.isMultiLine()) {
            out.append("\"\"\"");
            if (description.getContent().isEmpty() || description.getContent().charAt(0) != '\n') {
                out.append('\n');
            }
            out.append(description.getContent());
            out.append("\n\"\"\"\n");
        } else {
            out.append('\"');
            EscapeUtil.escapeJsonStringTo(out, description.getContent());
            out.append("\"\n");
        }
    }

    private void directives(StringBuilder out, List<Directive> directives) {
        this.join(out, AstPrinter.nvl(directives), this.compactMode ? "" : " ");
    }

    private <T extends Node<?>> void join(StringBuilder out, List<T> nodes, String delim) {
        if (AstPrinter.isEmpty(nodes)) {
            return;
        }
        Iterator<T> iterator2 = nodes.iterator();
        this.node(out, (Node)iterator2.next());
        while (iterator2.hasNext()) {
            out.append(delim);
            this.node(out, (Node)iterator2.next());
        }
    }

    private <T extends Node<?>> void joinTight(StringBuilder output, List<T> nodes, String delim, String prefix, String suffix) {
        output.append(prefix);
        boolean first = true;
        for (Node node : nodes) {
            if (first) {
                first = false;
            } else if (output.charAt(output.length() - 1) != '}') {
                output.append(delim);
            }
            this.node(output, node);
        }
        output.append(suffix);
    }

    String wrap(String start2, String maybeString, String end) {
        if (AstPrinter.isEmpty(maybeString)) {
            if (start2.equals("\"") && end.equals("\"")) {
                return "\"\"";
            }
            return "";
        }
        return start2 + maybeString + (!AstPrinter.isEmpty(end) ? end : "");
    }

    private <T extends Node<?>> void block(StringBuilder out, List<T> nodes) {
        if (AstPrinter.isEmpty(nodes)) {
            return;
        }
        if (this.compactMode) {
            out.append('{');
            this.joinTight(out, nodes, " ", "", "");
            out.append('}');
        } else {
            int offset = out.length();
            out.append("{\n");
            this.join(out, nodes, "\n");
            AstPrinter.indent(out, offset);
            out.append("\n}");
        }
    }

    private static void indent(StringBuilder maybeString, int offset) {
        for (int i = offset; i < maybeString.length(); ++i) {
            char c = maybeString.charAt(i);
            if (c != '\n') continue;
            maybeString.replace(i, i + 1, "\n  ");
            i += 3;
        }
    }

    String wrap(String start2, Node maybeNode, String end) {
        if (maybeNode == null) {
            return "";
        }
        return start2 + this.node(maybeNode) + (AstPrinter.isEmpty(end) ? "" : end);
    }

    public static String printAst(Node node) {
        StringBuilder builder = new StringBuilder();
        AstPrinter.printAstTo(node, builder);
        return builder.toString();
    }

    public static void printAstTo(Node<?> node, Appendable appendable) {
        if (appendable instanceof StringBuilder) {
            AstPrinter.printImpl((StringBuilder)appendable, node, false);
        } else if (appendable instanceof Writer) {
            AstPrinter.printAst((Writer)appendable, node);
        } else {
            StringBuilder builder = new StringBuilder();
            AstPrinter.printImpl(builder, node, false);
            try {
                appendable.append(builder);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static void printAst(Writer writer, Node node) {
        String ast = AstPrinter.printAst(node);
        try {
            writer.write(ast);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String printAstCompact(Node node) {
        StringBuilder builder = new StringBuilder();
        AstPrinter.printImpl(builder, node, true);
        return builder.toString();
    }

    private static void printImpl(StringBuilder writer, Node<?> node, boolean compactMode) {
        AstPrinter astPrinter = new AstPrinter(compactMode);
        NodePrinter<Node<?>> printer = astPrinter._findPrinter(node);
        printer.print(writer, node);
    }

    void replacePrinter(Class<? extends Node> nodeClass, NodePrinter<? extends Node> nodePrinter) {
        this.printers.put(nodeClass, nodePrinter);
    }

    static interface NodePrinter<T extends Node> {
        public void print(StringBuilder var1, T var2);
    }
}

