/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.DirectiveDefinition;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.NonUniqueArgumentError;
import graphql.schema.idl.errors.NonUniqueNameError;
import graphql.schema.idl.errors.TypeExtensionEnumValueRedefinitionError;
import graphql.schema.idl.errors.TypeExtensionFieldRedefinitionError;
import graphql.schema.idl.errors.TypeExtensionMissingBaseTypeError;
import graphql.util.FpKit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Internal
class SchemaTypeExtensionsChecker {
    SchemaTypeExtensionsChecker() {
    }

    void checkTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry) {
        Map<String, DirectiveDefinition> directiveDefinitionMap = typeRegistry.getDirectiveDefinitions();
        this.checkObjectTypeExtensions(errors2, typeRegistry, directiveDefinitionMap);
        this.checkInterfaceTypeExtensions(errors2, typeRegistry, directiveDefinitionMap);
        this.checkUnionTypeExtensions(errors2, typeRegistry, directiveDefinitionMap);
        this.checkEnumTypeExtensions(errors2, typeRegistry, directiveDefinitionMap);
        this.checkScalarTypeExtensions(errors2, typeRegistry, directiveDefinitionMap);
        this.checkInputObjectTypeExtensions(errors2, typeRegistry, directiveDefinitionMap);
    }

    private void checkObjectTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        typeRegistry.objectTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors2, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)ObjectTypeDefinition.class);
            extensions.forEach(extension -> {
                List<FieldDefinition> fieldDefinitions = extension.getFieldDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors2, extension.getFieldDefinitions(), FieldDefinition::getName, (namedField, fieldDef) -> new NonUniqueNameError((TypeDefinition)extension, (FieldDefinition)fieldDef));
                extension.getFieldDefinitions().forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors2, fld.getInputValueDefinitions(), InputValueDefinition::getName, (namedField, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)name)));
                fieldDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)argumentName))));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForFieldRedefinition(errors2, (TypeDefinition)otherTypeExt, otherTypeExt.getFieldDefinitions(), fieldDefinitions));
                Optional<ObjectTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), ObjectTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForFieldRedefinition(errors2, (TypeDefinition)extension, fieldDefinitions, baseTypeDef.getFieldDefinitions()));
            });
        });
    }

    private void checkInterfaceTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        typeRegistry.interfaceTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors2, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)InterfaceTypeDefinition.class);
            extensions.forEach(extension -> {
                List<FieldDefinition> fieldDefinitions = extension.getFieldDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors2, extension.getFieldDefinitions(), FieldDefinition::getName, (namedField, fieldDef) -> new NonUniqueNameError((TypeDefinition)extension, (FieldDefinition)fieldDef));
                extension.getFieldDefinitions().forEach(fld -> SchemaTypeChecker.checkNamedUniqueness(errors2, fld.getInputValueDefinitions(), InputValueDefinition::getName, (namedField, inputValueDefinition) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)name)));
                fieldDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)extension, (FieldDefinition)fld, (String)argumentName))));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForFieldRedefinition(errors2, (TypeDefinition)otherTypeExt, otherTypeExt.getFieldDefinitions(), fieldDefinitions));
                Optional<InterfaceTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), InterfaceTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForFieldRedefinition(errors2, (TypeDefinition)extension, fieldDefinitions, baseTypeDef.getFieldDefinitions()));
            });
        });
    }

    private void checkUnionTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        typeRegistry.unionTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors2, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)UnionTypeDefinition.class);
            extensions.forEach(extension -> {
                List<TypeName> memberTypes = extension.getMemberTypes().stream().map(t2 -> TypeInfo.typeInfo(t2).getTypeName()).collect(Collectors.toList());
                SchemaTypeChecker.checkNamedUniqueness(errors2, memberTypes, TypeName::getName, (namedMember, memberType) -> new NonUniqueNameError((UnionTypeDefinition)extension, (String)namedMember));
                memberTypes.forEach(memberType -> {
                    Optional<ObjectTypeDefinition> unionTypeDefinition = typeRegistry.getType((Type)memberType, ObjectTypeDefinition.class);
                    if (!unionTypeDefinition.isPresent()) {
                        errors2.add(new MissingTypeError("union member", (TypeDefinition)extension, (TypeName)memberType));
                    }
                });
            });
        });
    }

    private void checkEnumTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        typeRegistry.enumTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors2, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)EnumTypeDefinition.class);
            extensions.forEach(extension -> {
                List<EnumValueDefinition> enumValueDefinitions = extension.getEnumValueDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors2, enumValueDefinitions, EnumValueDefinition::getName, (namedField, enumValue) -> new NonUniqueNameError((TypeDefinition)extension, (EnumValueDefinition)enumValue));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForEnumValueRedefinition(errors2, (TypeDefinition)otherTypeExt, otherTypeExt.getEnumValueDefinitions(), enumValueDefinitions));
                Optional<EnumTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), EnumTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForEnumValueRedefinition(errors2, (TypeDefinition)extension, enumValueDefinitions, baseTypeDef.getEnumValueDefinitions()));
            });
        });
    }

    private void checkScalarTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        typeRegistry.scalarTypeExtensions().forEach((name, extensions) -> this.checkTypeExtensionHasCorrespondingType(errors2, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)ScalarTypeDefinition.class));
    }

    private void checkInputObjectTypeExtensions(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, Map<String, DirectiveDefinition> directiveDefinitionMap) {
        typeRegistry.inputObjectTypeExtensions().forEach((name, extensions) -> {
            this.checkTypeExtensionHasCorrespondingType(errors2, typeRegistry, (String)name, (List<? extends TypeDefinition>)extensions, (Class<? extends TypeDefinition>)InputObjectTypeDefinition.class);
            extensions.forEach(extension -> {
                List<InputValueDefinition> inputValueDefinitions = extension.getInputValueDefinitions();
                SchemaTypeChecker.checkNamedUniqueness(errors2, inputValueDefinitions, InputValueDefinition::getName, (namedField, fieldDef) -> new NonUniqueNameError((InputObjectTypeDefinition)extension, (InputValueDefinition)fieldDef));
                inputValueDefinitions.forEach(fld -> fld.getDirectives().forEach(directive -> SchemaTypeChecker.checkNamedUniqueness(errors2, directive.getArguments(), Argument::getName, (argumentName, argument) -> new NonUniqueArgumentError((TypeDefinition)extension, (InputValueDefinition)fld, (String)argumentName))));
                this.forEachBut((Object)extension, (List)extensions, otherTypeExt -> this.checkForInputValueRedefinition(errors2, (InputObjectTypeExtensionDefinition)otherTypeExt, otherTypeExt.getInputValueDefinitions(), inputValueDefinitions));
                Optional<InputObjectTypeDefinition> baseTypeOpt = typeRegistry.getType(extension.getName(), InputObjectTypeDefinition.class);
                baseTypeOpt.ifPresent(baseTypeDef -> this.checkForInputValueRedefinition(errors2, (InputObjectTypeExtensionDefinition)extension, inputValueDefinitions, baseTypeDef.getInputValueDefinitions()));
            });
        });
    }

    private void checkTypeExtensionHasCorrespondingType(List<GraphQLError> errors2, TypeDefinitionRegistry typeRegistry, String name, List<? extends TypeDefinition> extTypeList, Class<? extends TypeDefinition> targetClass) {
        TypeDefinition extensionDefinition = extTypeList.get(0);
        Optional<? extends TypeDefinition> typeDefinition = typeRegistry.getType(TypeName.newTypeName().name(name).build(), targetClass);
        if (!typeDefinition.isPresent()) {
            errors2.add(new TypeExtensionMissingBaseTypeError(extensionDefinition));
        }
    }

    private void checkForFieldRedefinition(List<GraphQLError> errors2, TypeDefinition typeDefinition, List<FieldDefinition> fieldDefinitions, List<FieldDefinition> referenceFieldDefinitions) {
        Map<String, FieldDefinition> referenceMap = FpKit.getByName(referenceFieldDefinitions, FieldDefinition::getName, FpKit.mergeFirst());
        fieldDefinitions.forEach(fld -> {
            if (referenceMap.containsKey(fld.getName())) {
                errors2.add(new TypeExtensionFieldRedefinitionError(typeDefinition, (FieldDefinition)fld));
            }
        });
    }

    private void checkForInputValueRedefinition(List<GraphQLError> errors2, InputObjectTypeExtensionDefinition typeDefinition, List<InputValueDefinition> inputValueDefinitions, List<InputValueDefinition> referenceInputValues) {
        Map<String, InputValueDefinition> referenceMap = FpKit.getByName(referenceInputValues, InputValueDefinition::getName, FpKit.mergeFirst());
        inputValueDefinitions.forEach(fld -> {
            if (referenceMap.containsKey(fld.getName())) {
                errors2.add(new TypeExtensionFieldRedefinitionError((TypeDefinition)typeDefinition, (InputValueDefinition)fld));
            }
        });
    }

    private void checkForEnumValueRedefinition(List<GraphQLError> errors2, TypeDefinition typeDefinition, List<EnumValueDefinition> enumValueDefinitions, List<EnumValueDefinition> referenceEnumValueDefinitions) {
        Map<String, EnumValueDefinition> referenceMap = FpKit.getByName(referenceEnumValueDefinitions, EnumValueDefinition::getName, FpKit.mergeFirst());
        enumValueDefinitions.forEach(fld -> {
            if (referenceMap.containsKey(fld.getName())) {
                errors2.add(new TypeExtensionEnumValueRedefinitionError(typeDefinition, (EnumValueDefinition)fld));
            }
        });
    }

    private <T> void forEachBut(T butThisOne, List<T> list, Consumer<T> consumer) {
        for (T t2 : list) {
            if (t2 == butThisOne) continue;
            consumer.accept(t2);
        }
    }
}

