/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.managers.ChromeDriverManager;
import java.nio.file.Path;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.net.PortProber;

public class ChromiumDriverManager
extends ChromeDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.CHROMIUM;
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getChromiumDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getChromiumVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setChromiumDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setChromiumVersion(browserVersion);
    }

    @Override
    protected Capabilities getCapabilities() {
        ChromeOptions options = new ChromeOptions();
        if (!this.isUsingDocker()) {
            Optional<Path> browserPath = this.getBrowserPath();
            if (browserPath.isPresent()) {
                options.setBinary(browserPath.get().toFile());
            }
            options.addArguments("--no-sandbox");
            options.addArguments("--disable-gpu");
            options.addArguments("--disable-dev-shm-usage");
            options.addArguments("--remote-debugging-port=" + PortProber.findFreePort());
        }
        return options;
    }
}

