/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.online.GeckodriverSupport;
import io.github.bonigarcia.wdm.online.Parser;
import io.github.bonigarcia.wdm.versions.Shell;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxOptions;

public class FirefoxDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.FIREFOX;
    }

    @Override
    protected String getDriverName() {
        return "geckodriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getGeckoDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getFirefoxVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setGeckoDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setFirefoxVersion(browserVersion);
    }

    @Override
    protected String getBrowserBinary() {
        return this.config().getFirefoxBinary();
    }

    @Override
    protected void setBrowserBinary(String browserBinary) {
        this.config().setFirefoxBinary(browserBinary);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getFirefoxDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getFirefoxDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getFirefoxDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url2) {
        this.config().setFirefoxDriverUrl(url2);
    }

    @Override
    protected List<URL> getDriverUrls(String driverVersion) throws IOException {
        if (this.isUseMirror()) {
            String versionPath = driverVersion;
            if (!driverVersion.isEmpty() && !driverVersion.equals("0.3.0")) {
                versionPath = "v" + versionPath;
            }
            return this.getDriversFromMirror(this.getMirrorUrl().get(), versionPath);
        }
        return this.getDriversFromGitHub(driverVersion);
    }

    @Override
    protected Optional<String> getLatestDriverVersionFromRepository() {
        if (this.config().isUseBetaVersions()) {
            return Optional.empty();
        }
        return this.getDriverVersionFromRepository(Optional.empty());
    }

    @Override
    protected String getCurrentVersion(URL url2) {
        int firstDash = url2.getFile().indexOf("-");
        int nextDash = url2.getFile().indexOf("-", firstDash + 1);
        String currentVersion = url2.getFile().substring(firstDash + 1, nextDash);
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        URL firefoxDriverUrl = this.config.getFirefoxDriverGoodVersionsUrl();
        try {
            log.debug("Reading {} to discover geckodriver version", (Object)firefoxDriverUrl);
            GeckodriverSupport versions = Parser.parseJson(this.httpClient, firefoxDriverUrl.toString(), GeckodriverSupport.class);
            if (this.resolvedBrowserVersion != null) {
                int majorBrowserVersion = Integer.parseInt(this.resolvedBrowserVersion);
                List fileteredList = versions.geckodriverReleases.stream().filter(r -> majorBrowserVersion >= r.minFirefoxVersion && (r.maxFirefoxVersion == null || r.maxFirefoxVersion != null && majorBrowserVersion <= r.maxFirefoxVersion)).collect(Collectors.toList());
                if (!fileteredList.isEmpty()) {
                    return Optional.of(((GeckodriverSupport.GeckodriverRelease)fileteredList.get((int)0)).geckodriverVersion);
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception getting geckodriver version from {}", (Object)firefoxDriverUrl, (Object)e);
        }
        return Optional.empty();
    }

    @Override
    protected Capabilities getCapabilities() {
        return new FirefoxOptions();
    }

    @Override
    protected List<File> postDownload(File archive) {
        List<File> fileList = super.postDownload(archive);
        if (this.config().getOperatingSystem().isMac()) {
            log.debug("Bypass notarization requirement for geckodriver on Mac OS");
            Shell.runAndWait(this.config.getTimeout(), "xattr", "-r", "-d", "com.apple.quarantine", fileList.iterator().next().toString());
        }
        return fileList;
    }

    @Override
    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setFirefoxDriverExport(exportParameter);
        return this;
    }
}

