/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

public class RegExUtils {
    public static Pattern dotAll(String regex2) {
        return Pattern.compile(regex2, 32);
    }

    public static Matcher dotAllMatcher(String regex2, CharSequence text) {
        return RegExUtils.dotAll(regex2).matcher(text);
    }

    @Deprecated
    public static Matcher dotAllMatcher(String regex2, String text) {
        return RegExUtils.dotAll(regex2).matcher(text);
    }

    public static String removeAll(CharSequence text, Pattern regex2) {
        return RegExUtils.replaceAll(text, regex2, "");
    }

    @Deprecated
    public static String removeAll(String text, Pattern regex2) {
        return RegExUtils.replaceAll((CharSequence)text, regex2, "");
    }

    public static String removeAll(String text, String regex2) {
        return RegExUtils.replaceAll(text, regex2, "");
    }

    public static String removeFirst(CharSequence text, Pattern regex2) {
        return RegExUtils.replaceFirst(text, regex2, "");
    }

    @Deprecated
    public static String removeFirst(String text, Pattern regex2) {
        return RegExUtils.replaceFirst(text, regex2, "");
    }

    public static String removeFirst(String text, String regex2) {
        return RegExUtils.replaceFirst(text, regex2, "");
    }

    public static String removePattern(CharSequence text, String regex2) {
        return RegExUtils.replacePattern(text, regex2, "");
    }

    @Deprecated
    public static String removePattern(String text, String regex2) {
        return RegExUtils.replacePattern((CharSequence)text, regex2, "");
    }

    public static String replaceAll(CharSequence text, Pattern regex2, String replacement) {
        if (ObjectUtils.anyNull(text, regex2, replacement)) {
            return RegExUtils.toStringOrNull(text);
        }
        return regex2.matcher(text).replaceAll(replacement);
    }

    @Deprecated
    public static String replaceAll(String text, Pattern regex2, String replacement) {
        return RegExUtils.replaceAll((CharSequence)text, regex2, replacement);
    }

    public static String replaceAll(String text, String regex2, String replacement) {
        if (ObjectUtils.anyNull(text, regex2, replacement)) {
            return text;
        }
        return text.replaceAll(regex2, replacement);
    }

    public static String replaceFirst(CharSequence text, Pattern regex2, String replacement) {
        if (text == null || regex2 == null || replacement == null) {
            return RegExUtils.toStringOrNull(text);
        }
        return regex2.matcher(text).replaceFirst(replacement);
    }

    @Deprecated
    public static String replaceFirst(String text, Pattern regex2, String replacement) {
        return RegExUtils.replaceFirst((CharSequence)text, regex2, replacement);
    }

    public static String replaceFirst(String text, String regex2, String replacement) {
        if (text == null || regex2 == null || replacement == null) {
            return text;
        }
        return text.replaceFirst(regex2, replacement);
    }

    public static String replacePattern(CharSequence text, String regex2, String replacement) {
        if (ObjectUtils.anyNull(text, regex2, replacement)) {
            return RegExUtils.toStringOrNull(text);
        }
        return RegExUtils.dotAllMatcher(regex2, text).replaceAll(replacement);
    }

    @Deprecated
    public static String replacePattern(String text, String regex2, String replacement) {
        return RegExUtils.replacePattern((CharSequence)text, regex2, replacement);
    }

    private static String toStringOrNull(CharSequence text) {
        return Objects.toString(text, null);
    }

    @Deprecated
    public RegExUtils() {
    }
}

