/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.core5.util.TextUtils;

public class SystemDefaultDnsResolver
implements DnsResolver {
    public static final SystemDefaultDnsResolver INSTANCE = new SystemDefaultDnsResolver();

    @Override
    public InetAddress[] resolve(String host2) throws UnknownHostException {
        try {
            String normalizedHost;
            if (TextUtils.isAllASCII(host2)) {
                normalizedHost = host2;
            } else {
                try {
                    normalizedHost = IDN.toASCII(host2);
                }
                catch (IllegalArgumentException e) {
                    normalizedHost = host2;
                }
            }
            return InetAddress.getAllByName(normalizedHost);
        }
        catch (UnknownHostException e) {
            int i;
            String strippedHost = null;
            if (host2.charAt(0) == '[' && (i = host2.lastIndexOf(37)) != -1) {
                strippedHost = host2.substring(0, i) + "]";
            }
            if (strippedHost != null) {
                return InetAddress.getAllByName(strippedHost);
            }
            throw e;
        }
    }

    @Override
    public String resolveCanonicalHostname(String host2) throws UnknownHostException {
        if (host2 == null) {
            return null;
        }
        InetAddress in = InetAddress.getByName(host2);
        String canonicalServer = in.getCanonicalHostName();
        if (in.getHostAddress().contentEquals(canonicalServer)) {
            return host2;
        }
        return canonicalServer;
    }
}

