/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.Host;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpHost
implements NamedEndpoint,
Serializable {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final URIScheme DEFAULT_SCHEME = URIScheme.HTTP;
    private final String schemeName;
    private final Host host;
    private final InetAddress address;

    public HttpHost(String scheme2, InetAddress address, String hostname, int port) {
        Args.containsNoBlanks(hostname, "Host name");
        this.host = new Host(hostname, port);
        this.schemeName = scheme2 != null ? TextUtils.toLowerCase(scheme2) : HttpHost.DEFAULT_SCHEME.id;
        this.address = address;
    }

    public HttpHost(String scheme2, String hostname, int port) {
        this(scheme2, null, hostname, port);
    }

    public HttpHost(String hostname, int port) {
        this(null, hostname, port);
    }

    public HttpHost(String scheme2, String hostname) {
        this(scheme2, hostname, -1);
    }

    public static HttpHost create(String s2) throws URISyntaxException {
        Args.notEmpty(s2, "HTTP Host");
        String text = s2;
        String scheme2 = null;
        int schemeIdx = text.indexOf("://");
        if (schemeIdx > 0) {
            scheme2 = text.substring(0, schemeIdx);
            if (TextUtils.containsBlanks(scheme2)) {
                throw new URISyntaxException(s2, "scheme contains blanks");
            }
            text = text.substring(schemeIdx + 3);
        }
        Host host2 = Host.create(text);
        return new HttpHost(scheme2, host2);
    }

    public static HttpHost create(URI uri2) {
        String scheme2 = uri2.getScheme();
        return new HttpHost(scheme2 != null ? scheme2 : URIScheme.HTTP.getId(), uri2.getHost(), uri2.getPort());
    }

    public HttpHost(String hostname) {
        this(null, hostname, -1);
    }

    public HttpHost(String scheme2, InetAddress address, int port) {
        this(scheme2, Args.notNull(address, "Inet address"), address.getHostName(), port);
    }

    public HttpHost(InetAddress address, int port) {
        this(null, address, port);
    }

    public HttpHost(InetAddress address) {
        this(null, address, -1);
    }

    public HttpHost(String scheme2, NamedEndpoint namedEndpoint) {
        this(scheme2, Args.notNull(namedEndpoint, "Named endpoint").getHostName(), namedEndpoint.getPort());
    }

    @Deprecated
    public HttpHost(URIAuthority authority) {
        this(null, authority);
    }

    @Override
    public String getHostName() {
        return this.host.getHostName();
    }

    @Override
    public int getPort() {
        return this.host.getPort();
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String toURI() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.schemeName);
        buffer.append("://");
        buffer.append(this.host.toString());
        return buffer.toString();
    }

    public String toHostString() {
        return this.host.toString();
    }

    public String toString() {
        return this.toURI();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpHost) {
            HttpHost that = (HttpHost)obj;
            return this.schemeName.equals(that.schemeName) && this.host.equals(that.host) && Objects.equals(this.address, that.address);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.schemeName);
        hash = LangUtils.hashCode(hash, this.host);
        hash = LangUtils.hashCode(hash, this.address);
        return hash;
    }
}

