/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.BatchPublisher;
import org.dataloader.BatchPublisherWithContext;
import org.dataloader.CacheMap;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DispatchResult;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.MappedBatchPublisher;
import org.dataloader.MappedBatchPublisherWithContext;
import org.dataloader.Try;
import org.dataloader.ValueCache;
import org.dataloader.annotations.GuardedBy;
import org.dataloader.annotations.Internal;
import org.dataloader.impl.Assertions;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.instrumentation.DataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentationContext;
import org.dataloader.instrumentation.DataLoaderInstrumentationHelper;
import org.dataloader.reactive.ReactiveSupport;
import org.dataloader.scheduler.BatchLoaderScheduler;
import org.dataloader.stats.StatisticsCollector;
import org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;
import org.reactivestreams.Subscriber;

@Internal
class DataLoaderHelper<K, V> {
    private final DataLoader<K, V> dataLoader;
    private final Object batchLoadFunction;
    private final DataLoaderOptions loaderOptions;
    private final CacheMap<Object, V> futureCache;
    private final ValueCache<K, V> valueCache;
    private final List<LoaderQueueEntry<K, CompletableFuture<V>>> loaderQueue;
    private final StatisticsCollector stats;
    private final Clock clock;
    private final AtomicReference<Instant> lastDispatchTime;
    private final List<Try<V>> NOT_SUPPORTED_LIST = Collections.emptyList();
    private final CompletableFuture<List<Try<V>>> NOT_SUPPORTED = CompletableFuture.completedFuture(this.NOT_SUPPORTED_LIST);
    private final Try<V> ALWAYS_FAILED = Try.alwaysFailed();
    private static final DispatchResult<?> EMPTY_DISPATCH_RESULT = new DispatchResult(CompletableFuture.completedFuture(Collections.emptyList()), 0);

    DataLoaderHelper(DataLoader<K, V> dataLoader, Object batchLoadFunction, DataLoaderOptions loaderOptions, CacheMap<Object, V> futureCache, ValueCache<K, V> valueCache, StatisticsCollector stats, Clock clock) {
        this.dataLoader = dataLoader;
        this.batchLoadFunction = batchLoadFunction;
        this.loaderOptions = loaderOptions;
        this.futureCache = futureCache;
        this.valueCache = valueCache;
        this.loaderQueue = new ArrayList<LoaderQueueEntry<K, CompletableFuture<V>>>();
        this.stats = stats;
        this.clock = clock;
        this.lastDispatchTime = new AtomicReference();
        this.lastDispatchTime.set(this.now());
    }

    Instant now() {
        return this.clock.instant();
    }

    public Instant getLastDispatchTime() {
        return this.lastDispatchTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CompletableFuture<V>> getIfPresent(K key) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            boolean cachingEnabled = this.loaderOptions.cachingEnabled();
            if (cachingEnabled) {
                Object cacheKey = this.getCacheKey(Assertions.nonNull(key));
                try {
                    CompletableFuture<V> cacheValue = this.futureCache.get(cacheKey);
                    if (cacheValue != null) {
                        this.stats.incrementCacheHitCount(new IncrementCacheHitCountStatisticsContext<K>(key));
                        return Optional.of(cacheValue);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CompletableFuture<V>> getIfCompleted(K key) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            CompletableFuture<V> promise;
            Optional<CompletableFuture<V>> cachedPromise = this.getIfPresent(key);
            if (cachedPromise.isPresent() && (promise = cachedPromise.get()).isDone()) {
                return cachedPromise;
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<V> load(K key, Object loadContext) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            boolean batchingEnabled = this.loaderOptions.batchingEnabled();
            boolean cachingEnabled = this.loaderOptions.cachingEnabled();
            this.stats.incrementLoadCount(new IncrementLoadCountStatisticsContext<K>(key, loadContext));
            DataLoaderInstrumentationContext<Object> ctx = DataLoaderInstrumentationHelper.ctxOrNoopCtx(this.instrumentation().beginLoad(this.dataLoader, key, loadContext));
            CompletableFuture<V> cf = cachingEnabled ? this.loadFromCache(key, loadContext, batchingEnabled) : this.queueOrInvokeLoader(key, loadContext, batchingEnabled, false);
            ctx.onDispatched();
            cf.whenComplete(ctx::onCompleted);
            return cf;
        }
    }

    Object getCacheKey(K key) {
        return this.loaderOptions.cacheKeyFunction().isPresent() ? this.loaderOptions.cacheKeyFunction().get().getKey(key) : key;
    }

    Object getCacheKeyWithContext(K key, Object context) {
        return this.loaderOptions.cacheKeyFunction().isPresent() ? this.loaderOptions.cacheKeyFunction().get().getKeyWithContext(key, context) : key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DispatchResult<V> dispatch() {
        ArrayList queuedFutures;
        ArrayList<Object> callContexts;
        ArrayList keys2;
        DataLoaderInstrumentationContext<DispatchResult<?>> instrCtx = DataLoaderInstrumentationHelper.ctxOrNoopCtx(this.instrumentation().beginDispatch(this.dataLoader));
        boolean batchingEnabled = this.loaderOptions.batchingEnabled();
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            int queueSize = this.loaderQueue.size();
            if (queueSize == 0) {
                this.lastDispatchTime.set(this.now());
                instrCtx.onDispatched();
                return this.endDispatchCtx(instrCtx, DataLoaderHelper.emptyDispatchResult());
            }
            keys2 = new ArrayList(queueSize);
            callContexts = new ArrayList<Object>(queueSize);
            queuedFutures = new ArrayList(queueSize);
            this.loaderQueue.forEach(entry -> {
                keys2.add(entry.getKey());
                queuedFutures.add((CompletableFuture)entry.getValue());
                callContexts.add(entry.getCallContext());
            });
            this.loaderQueue.clear();
            this.lastDispatchTime.set(this.now());
        }
        if (!batchingEnabled) {
            instrCtx.onDispatched();
            return this.endDispatchCtx(instrCtx, DataLoaderHelper.emptyDispatchResult());
        }
        int totalEntriesHandled = keys2.size();
        int maxBatchSize = this.loaderOptions.maxBatchSize();
        CompletableFuture<List<Object>> futureList = maxBatchSize > 0 && maxBatchSize < keys2.size() ? this.sliceIntoBatchesOfBatches(keys2, queuedFutures, callContexts, maxBatchSize) : this.dispatchQueueBatch(keys2, callContexts, queuedFutures);
        instrCtx.onDispatched();
        return this.endDispatchCtx(instrCtx, new DispatchResult(futureList, totalEntriesHandled));
    }

    private DispatchResult<V> endDispatchCtx(DataLoaderInstrumentationContext<DispatchResult<?>> instrCtx, DispatchResult<V> dispatchResult) {
        dispatchResult.getPromisedResults().whenComplete((result, throwable) -> instrCtx.onCompleted(dispatchResult, (Throwable)throwable));
        return dispatchResult;
    }

    private CompletableFuture<List<V>> sliceIntoBatchesOfBatches(List<K> keys2, List<CompletableFuture<V>> queuedFutures, List<Object> callContexts, int maxBatchSize) {
        int len = keys2.size();
        int batchCount = (int)Math.ceil((double)len / (double)maxBatchSize);
        ArrayList allBatches = new ArrayList(batchCount);
        for (int i = 0; i < batchCount; ++i) {
            int fromIndex = i * maxBatchSize;
            int toIndex = Math.min((i + 1) * maxBatchSize, len);
            List<K> subKeys = keys2.subList(fromIndex, toIndex);
            List<CompletableFuture<V>> subFutures = queuedFutures.subList(fromIndex, toIndex);
            List<Object> subCallContexts = callContexts.subList(fromIndex, toIndex);
            allBatches.add(this.dispatchQueueBatch(subKeys, subCallContexts, subFutures));
        }
        return CompletableFuture.allOf(allBatches.toArray(new CompletableFuture[0])).thenApply(v -> allBatches.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private CompletableFuture<List<V>> dispatchQueueBatch(List<K> keys2, List<Object> callContexts, List<CompletableFuture<V>> queuedFutures) {
        this.stats.incrementBatchLoadCountBy(keys2.size(), new IncrementBatchLoadCountByStatisticsContext<K>(keys2, callContexts));
        CompletableFuture<List<V>> batchLoad = this.invokeLoader(keys2, callContexts, queuedFutures, this.loaderOptions.cachingEnabled());
        return ((CompletableFuture)batchLoad.thenApply(values2 -> {
            this.assertResultSize(keys2, (List<V>)values2);
            if (this.isPublisher() || this.isMappedPublisher()) {
                return values2;
            }
            ArrayList clearCacheKeys = new ArrayList();
            for (int idx = 0; idx < queuedFutures.size(); ++idx) {
                Object key = keys2.get(idx);
                Object value = values2.get(idx);
                Object callContext = callContexts.get(idx);
                CompletableFuture future = (CompletableFuture)queuedFutures.get(idx);
                if (value instanceof Throwable) {
                    this.stats.incrementLoadErrorCount(new IncrementLoadErrorCountStatisticsContext(key, callContext));
                    future.completeExceptionally((Throwable)value);
                    clearCacheKeys.add(keys2.get(idx));
                    continue;
                }
                if (value instanceof Try) {
                    Try tryValue = (Try)value;
                    if (tryValue.isSuccess()) {
                        future.complete(tryValue.get());
                        continue;
                    }
                    this.stats.incrementLoadErrorCount(new IncrementLoadErrorCountStatisticsContext(key, callContext));
                    future.completeExceptionally(tryValue.getThrowable());
                    clearCacheKeys.add(keys2.get(idx));
                    continue;
                }
                future.complete(value);
            }
            this.possiblyClearCacheEntriesOnExceptions(clearCacheKeys);
            return values2;
        })).exceptionally(ex -> {
            this.stats.incrementBatchLoadExceptionCount(new IncrementBatchLoadExceptionCountStatisticsContext(keys2, callContexts));
            if (ex instanceof CompletionException) {
                ex = ex.getCause();
            }
            for (int idx = 0; idx < queuedFutures.size(); ++idx) {
                Object key = keys2.get(idx);
                CompletableFuture future = (CompletableFuture)queuedFutures.get(idx);
                future.completeExceptionally((Throwable)ex);
                this.dataLoader.clear(key);
            }
            return Collections.emptyList();
        });
    }

    private void assertResultSize(List<K> keys2, List<V> values2) {
        Assertions.assertState(keys2.size() == values2.size(), () -> "The size of the promised values MUST be the same size as the key list");
    }

    private void possiblyClearCacheEntriesOnExceptions(List<K> keys2) {
        if (keys2.isEmpty()) {
            return;
        }
        if (!this.loaderOptions.cachingExceptionsEnabled()) {
            keys2.forEach(this.dataLoader::clear);
        }
    }

    @GuardedBy(value="dataLoader")
    private CompletableFuture<V> loadFromCache(K key, Object loadContext, boolean batchingEnabled) {
        Object cacheKey = loadContext == null ? this.getCacheKey(key) : this.getCacheKeyWithContext(key, loadContext);
        try {
            CompletableFuture<V> cacheValue = this.futureCache.get(cacheKey);
            if (cacheValue != null) {
                this.stats.incrementCacheHitCount(new IncrementCacheHitCountStatisticsContext<K>(key, loadContext));
                return cacheValue;
            }
        }
        catch (Exception cacheValue) {
            // empty catch block
        }
        CompletableFuture<V> loadCallFuture = this.queueOrInvokeLoader(key, loadContext, batchingEnabled, true);
        this.futureCache.set(cacheKey, loadCallFuture);
        return loadCallFuture;
    }

    @GuardedBy(value="dataLoader")
    private CompletableFuture<V> queueOrInvokeLoader(K key, Object loadContext, boolean batchingEnabled, boolean cachingEnabled) {
        if (batchingEnabled) {
            CompletableFuture loadCallFuture = new CompletableFuture();
            this.loaderQueue.add(new LoaderQueueEntry(key, loadCallFuture, loadContext));
            return loadCallFuture;
        }
        this.stats.incrementBatchLoadCountBy(1L, new IncrementBatchLoadCountByStatisticsContext<K>(key, loadContext));
        return this.invokeLoaderImmediately(key, loadContext, cachingEnabled);
    }

    CompletableFuture<V> invokeLoaderImmediately(K key, Object keyContext, boolean cachingEnabled) {
        List<K> keys2 = Collections.singletonList(key);
        List<Object> keyContexts = Collections.singletonList(keyContext);
        List<CompletableFuture<V>> queuedFutures = Collections.singletonList(new CompletableFuture());
        return ((CompletableFuture)this.invokeLoader(keys2, keyContexts, queuedFutures, cachingEnabled).thenApply(list -> list.get(0))).toCompletableFuture();
    }

    CompletableFuture<List<V>> invokeLoader(List<K> keys2, List<Object> keyContexts, List<CompletableFuture<V>> queuedFutures, boolean cachingEnabled) {
        if (!cachingEnabled) {
            return this.invokeLoader(keys2, keyContexts, queuedFutures);
        }
        CompletableFuture<List<Try<V>>> cacheCallCF = this.getFromValueCache(keys2);
        return cacheCallCF.thenCompose(cachedValues -> {
            int i;
            ArrayList<Try> valuesInKeyOrder = new ArrayList<Try>();
            ArrayList<Integer> missedKeyIndexes = new ArrayList<Integer>();
            ArrayList missedKeys = new ArrayList();
            ArrayList<Object> missedKeyContexts = new ArrayList<Object>();
            ArrayList<CompletableFuture<V>> missedQueuedFutures = new ArrayList<CompletableFuture<V>>();
            if (cachedValues == this.NOT_SUPPORTED_LIST) {
                for (i = 0; i < keys2.size(); ++i) {
                    valuesInKeyOrder.add(this.ALWAYS_FAILED);
                    missedKeyIndexes.add(i);
                    missedKeys.add(keys2.get(i));
                    missedKeyContexts.add(keyContexts.get(i));
                    missedQueuedFutures.add((CompletableFuture)queuedFutures.get(i));
                }
            } else {
                Assertions.assertState(keys2.size() == cachedValues.size(), () -> "The size of the cached values MUST be the same size as the key list");
                for (i = 0; i < keys2.size(); ++i) {
                    Try cacheGet = (Try)cachedValues.get(i);
                    valuesInKeyOrder.add(cacheGet);
                    if (cacheGet.isFailure()) {
                        missedKeyIndexes.add(i);
                        missedKeys.add(keys2.get(i));
                        missedKeyContexts.add(keyContexts.get(i));
                        missedQueuedFutures.add((CompletableFuture)queuedFutures.get(i));
                        continue;
                    }
                    ((CompletableFuture)queuedFutures.get(i)).complete(cacheGet.get());
                }
            }
            if (missedKeys.isEmpty()) {
                List assembledValues = valuesInKeyOrder.stream().map(Try::get).collect(Collectors.toList());
                return CompletableFuture.completedFuture(assembledValues);
            }
            CompletableFuture<List<V>> batchLoad = this.invokeLoader(missedKeys, missedKeyContexts, missedQueuedFutures);
            return batchLoad.thenCompose(missedValues -> {
                this.assertResultSize(missedKeys, (List<V>)missedValues);
                for (int i = 0; i < missedValues.size(); ++i) {
                    Object v = missedValues.get(i);
                    Integer listIndex = (Integer)missedKeyIndexes.get(i);
                    valuesInKeyOrder.set(listIndex, Try.succeeded(v));
                }
                List assembledValues = valuesInKeyOrder.stream().map(Try::get).collect(Collectors.toList());
                return this.setToValueCache(assembledValues, missedKeys, (List<V>)missedValues);
            });
        });
    }

    CompletableFuture<List<V>> invokeLoader(List<K> keys2, List<Object> keyContexts, List<CompletableFuture<V>> queuedFutures) {
        CompletableFuture<List<V>> batchLoad;
        Object context = this.loaderOptions.getBatchLoaderContextProvider().getContext();
        BatchLoaderEnvironment environment = BatchLoaderEnvironment.newBatchLoaderEnvironment().context(context).keyContexts(keys2, keyContexts).build();
        DataLoaderInstrumentationContext<List<?>> instrCtx = DataLoaderInstrumentationHelper.ctxOrNoopCtx(this.instrumentation().beginBatchLoader(this.dataLoader, keys2, environment));
        try {
            batchLoad = this.isMapLoader() ? this.invokeMapBatchLoader(keys2, environment) : (this.isPublisher() ? this.invokeBatchPublisher(keys2, keyContexts, queuedFutures, environment) : (this.isMappedPublisher() ? this.invokeMappedBatchPublisher(keys2, keyContexts, queuedFutures, environment) : this.invokeListBatchLoader(keys2, environment)));
            instrCtx.onDispatched();
        }
        catch (Exception e) {
            instrCtx.onDispatched();
            batchLoad = CompletableFutureKit.failedFuture(e);
        }
        batchLoad.whenComplete(instrCtx::onCompleted);
        return batchLoad;
    }

    private CompletableFuture<List<V>> invokeListBatchLoader(List<K> keys2, BatchLoaderEnvironment environment) {
        CompletionStage loadResult;
        BatchLoaderScheduler batchLoaderScheduler = this.loaderOptions.getBatchLoaderScheduler();
        if (this.batchLoadFunction instanceof BatchLoaderWithContext) {
            BatchLoaderWithContext loadFunction = (BatchLoaderWithContext)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledBatchLoaderCall loadCall = () -> loadFunction.load(keys2, environment);
                loadResult = batchLoaderScheduler.scheduleBatchLoader(loadCall, keys2, environment);
            } else {
                loadResult = loadFunction.load(keys2, environment);
            }
        } else {
            BatchLoader loadFunction = (BatchLoader)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledBatchLoaderCall loadCall = () -> loadFunction.load(keys2);
                loadResult = batchLoaderScheduler.scheduleBatchLoader(loadCall, keys2, null);
            } else {
                loadResult = loadFunction.load(keys2);
            }
        }
        return Assertions.nonNull(loadResult, () -> "Your batch loader function MUST return a non null CompletionStage").toCompletableFuture();
    }

    private CompletableFuture<List<V>> invokeMapBatchLoader(List<K> keys2, BatchLoaderEnvironment environment) {
        CompletionStage loadResult;
        Object loadFunction;
        LinkedHashSet<K> setOfKeys = new LinkedHashSet<K>(keys2);
        BatchLoaderScheduler batchLoaderScheduler = this.loaderOptions.getBatchLoaderScheduler();
        if (this.batchLoadFunction instanceof MappedBatchLoaderWithContext) {
            loadFunction = (MappedBatchLoaderWithContext)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledMappedBatchLoaderCall loadCall = () -> DataLoaderHelper.lambda$invokeMapBatchLoader$13((MappedBatchLoaderWithContext)loadFunction, setOfKeys, environment);
                loadResult = batchLoaderScheduler.scheduleMappedBatchLoader(loadCall, keys2, environment);
            } else {
                loadResult = loadFunction.load(setOfKeys, environment);
            }
        } else {
            loadFunction = (MappedBatchLoader)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledMappedBatchLoaderCall loadCall = () -> DataLoaderHelper.lambda$invokeMapBatchLoader$14((MappedBatchLoader)loadFunction, setOfKeys);
                loadResult = batchLoaderScheduler.scheduleMappedBatchLoader(loadCall, keys2, null);
            } else {
                loadResult = loadFunction.load(setOfKeys);
            }
        }
        CompletableFuture mapBatchLoad = Assertions.nonNull(loadResult, () -> "Your batch loader function MUST return a non null CompletionStage").toCompletableFuture();
        return mapBatchLoad.thenApply(map -> {
            ArrayList values2 = new ArrayList(keys2.size());
            for (Object key : keys2) {
                Object value = map.get(key);
                values2.add(value);
            }
            return values2;
        });
    }

    private CompletableFuture<List<V>> invokeBatchPublisher(List<K> keys2, List<Object> keyContexts, List<CompletableFuture<V>> queuedFutures, BatchLoaderEnvironment environment) {
        CompletableFuture loadResult = new CompletableFuture();
        Subscriber subscriber = ReactiveSupport.batchSubscriber(loadResult, keys2, keyContexts, queuedFutures, this.helperIntegration());
        BatchLoaderScheduler batchLoaderScheduler = this.loaderOptions.getBatchLoaderScheduler();
        if (this.batchLoadFunction instanceof BatchPublisherWithContext) {
            BatchPublisherWithContext loadFunction = (BatchPublisherWithContext)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledBatchPublisherCall loadCall = () -> loadFunction.load(keys2, subscriber, environment);
                batchLoaderScheduler.scheduleBatchPublisher(loadCall, keys2, environment);
            } else {
                loadFunction.load(keys2, subscriber, environment);
            }
        } else {
            BatchPublisher loadFunction = (BatchPublisher)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledBatchPublisherCall loadCall = () -> loadFunction.load(keys2, subscriber);
                batchLoaderScheduler.scheduleBatchPublisher(loadCall, keys2, null);
            } else {
                loadFunction.load(keys2, subscriber);
            }
        }
        return loadResult;
    }

    private CompletableFuture<List<V>> invokeMappedBatchPublisher(List<K> keys2, List<Object> keyContexts, List<CompletableFuture<V>> queuedFutures, BatchLoaderEnvironment environment) {
        CompletableFuture loadResult = new CompletableFuture();
        Subscriber subscriber = ReactiveSupport.mappedBatchSubscriber(loadResult, keys2, keyContexts, queuedFutures, this.helperIntegration());
        LinkedHashSet setOfKeys = new LinkedHashSet(keys2);
        BatchLoaderScheduler batchLoaderScheduler = this.loaderOptions.getBatchLoaderScheduler();
        if (this.batchLoadFunction instanceof MappedBatchPublisherWithContext) {
            MappedBatchPublisherWithContext loadFunction = (MappedBatchPublisherWithContext)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledBatchPublisherCall loadCall = () -> loadFunction.load(keys2, subscriber, environment);
                batchLoaderScheduler.scheduleBatchPublisher(loadCall, keys2, environment);
            } else {
                loadFunction.load(keys2, subscriber, environment);
            }
        } else {
            MappedBatchPublisher loadFunction = (MappedBatchPublisher)this.batchLoadFunction;
            if (batchLoaderScheduler != null) {
                BatchLoaderScheduler.ScheduledBatchPublisherCall loadCall = () -> loadFunction.load(setOfKeys, subscriber);
                batchLoaderScheduler.scheduleBatchPublisher(loadCall, keys2, null);
            } else {
                loadFunction.load(setOfKeys, subscriber);
            }
        }
        return loadResult;
    }

    private boolean isMapLoader() {
        return this.batchLoadFunction instanceof MappedBatchLoader || this.batchLoadFunction instanceof MappedBatchLoaderWithContext;
    }

    private boolean isPublisher() {
        return this.batchLoadFunction instanceof BatchPublisher;
    }

    private boolean isMappedPublisher() {
        return this.batchLoadFunction instanceof MappedBatchPublisher;
    }

    private DataLoaderInstrumentation instrumentation() {
        return this.loaderOptions.getInstrumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dispatchDepth() {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            return this.loaderQueue.size();
        }
    }

    private CompletableFuture<List<Try<V>>> getFromValueCache(List<K> keys2) {
        try {
            return Assertions.nonNull(this.valueCache.getValues(keys2), () -> "Your ValueCache.getValues function MUST return a non null CompletableFuture");
        }
        catch (ValueCache.ValueCachingNotSupported ignored) {
            return this.NOT_SUPPORTED;
        }
        catch (RuntimeException e) {
            return CompletableFutureKit.failedFuture(e);
        }
    }

    private CompletableFuture<List<V>> setToValueCache(List<V> assembledValues, List<K> missedKeys, List<V> missedValues) {
        try {
            boolean completeValueAfterCacheSet = this.loaderOptions.getValueCacheOptions().isCompleteValueAfterCacheSet();
            if (completeValueAfterCacheSet) {
                return Assertions.nonNull(this.valueCache.setValues(missedKeys, missedValues), () -> "Your ValueCache.setValues function MUST return a non null CompletableFuture").handle((ignored, setExIgnored) -> assembledValues);
            }
            this.valueCache.setValues(missedKeys, missedValues);
        }
        catch (ValueCache.ValueCachingNotSupported valueCachingNotSupported) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(assembledValues);
    }

    private static <T> DispatchResult<T> emptyDispatchResult() {
        return EMPTY_DISPATCH_RESULT;
    }

    private ReactiveSupport.HelperIntegration<K> helperIntegration() {
        return new ReactiveSupport.HelperIntegration<K>(){

            @Override
            public StatisticsCollector getStats() {
                return DataLoaderHelper.this.stats;
            }

            @Override
            public void clearCacheView(K key) {
                DataLoaderHelper.this.dataLoader.clear(key);
            }

            @Override
            public void clearCacheEntriesOnExceptions(List<K> keys2) {
                DataLoaderHelper.this.possiblyClearCacheEntriesOnExceptions(keys2);
            }
        };
    }

    private static /* synthetic */ CompletionStage lambda$invokeMapBatchLoader$14(MappedBatchLoader loadFunction, Set setOfKeys) {
        return loadFunction.load(setOfKeys);
    }

    private static /* synthetic */ CompletionStage lambda$invokeMapBatchLoader$13(MappedBatchLoaderWithContext loadFunction, Set setOfKeys, BatchLoaderEnvironment environment) {
        return loadFunction.load(setOfKeys, environment);
    }

    static class LoaderQueueEntry<K, V> {
        final K key;
        final V value;
        final Object callContext;

        public LoaderQueueEntry(K key, V value, Object callContext) {
            this.key = key;
            this.value = value;
            this.callContext = callContext;
        }

        K getKey() {
            return this.key;
        }

        V getValue() {
            return this.value;
        }

        Object getCallContext() {
            return this.callContext;
        }
    }
}

