/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.script.LocalValue;

public class RemoteReference
extends LocalValue {
    private String handle;
    private String sharedId;

    public RemoteReference(String handle2, String sharedId) {
        this.handle = handle2;
        this.sharedId = sharedId;
    }

    public RemoteReference(Type type, String value) {
        if (Type.HANDLE.equals((Object)type)) {
            this.handle = value;
        } else {
            this.sharedId = value;
        }
    }

    @Override
    public Map<String, Object> toJson() {
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        if (this.handle != null) {
            toReturn.put(Type.HANDLE.toString(), this.handle);
        }
        if (this.sharedId != null) {
            toReturn.put(Type.SHARED_ID.toString(), this.sharedId);
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public static enum Type {
        HANDLE("handle"),
        SHARED_ID("sharedId");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

