/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.audits.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v137.audits.model.CookieOperation;
import org.openqa.selenium.json.JsonInput;

public class CookieDeprecationMetadataIssueDetails {
    private final List<String> allowedSites;
    private final Number optOutPercentage;
    private final Boolean isOptOutTopLevel;
    private final CookieOperation operation;

    public CookieDeprecationMetadataIssueDetails(List<String> allowedSites, Number optOutPercentage, Boolean isOptOutTopLevel, CookieOperation operation) {
        this.allowedSites = Objects.requireNonNull(allowedSites, "allowedSites is required");
        this.optOutPercentage = Objects.requireNonNull(optOutPercentage, "optOutPercentage is required");
        this.isOptOutTopLevel = Objects.requireNonNull(isOptOutTopLevel, "isOptOutTopLevel is required");
        this.operation = Objects.requireNonNull(operation, "operation is required");
    }

    public List<String> getAllowedSites() {
        return this.allowedSites;
    }

    public Number getOptOutPercentage() {
        return this.optOutPercentage;
    }

    public Boolean getIsOptOutTopLevel() {
        return this.isOptOutTopLevel;
    }

    public CookieOperation getOperation() {
        return this.operation;
    }

    private static CookieDeprecationMetadataIssueDetails fromJson(JsonInput input) {
        List allowedSites = null;
        Number optOutPercentage = 0;
        Boolean isOptOutTopLevel = false;
        CookieOperation operation = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "allowedSites": {
                    allowedSites = input.readArray((Type)((Object)String.class));
                    continue block12;
                }
                case "optOutPercentage": {
                    optOutPercentage = input.nextNumber();
                    continue block12;
                }
                case "isOptOutTopLevel": {
                    isOptOutTopLevel = input.nextBoolean();
                    continue block12;
                }
                case "operation": {
                    operation = (CookieOperation)((Object)input.read((Type)((Object)CookieOperation.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookieDeprecationMetadataIssueDetails(allowedSites, optOutPercentage, isOptOutTopLevel, operation);
    }
}

