/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.browser.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum PermissionType {
    AR("ar"),
    AUDIOCAPTURE("audioCapture"),
    AUTOMATICFULLSCREEN("automaticFullscreen"),
    BACKGROUNDFETCH("backgroundFetch"),
    BACKGROUNDSYNC("backgroundSync"),
    CAMERAPANTILTZOOM("cameraPanTiltZoom"),
    CAPTUREDSURFACECONTROL("capturedSurfaceControl"),
    CLIPBOARDREADWRITE("clipboardReadWrite"),
    CLIPBOARDSANITIZEDWRITE("clipboardSanitizedWrite"),
    DISPLAYCAPTURE("displayCapture"),
    DURABLESTORAGE("durableStorage"),
    GEOLOCATION("geolocation"),
    HANDTRACKING("handTracking"),
    IDLEDETECTION("idleDetection"),
    KEYBOARDLOCK("keyboardLock"),
    LOCALFONTS("localFonts"),
    LOCALNETWORKACCESS("localNetworkAccess"),
    MIDI("midi"),
    MIDISYSEX("midiSysex"),
    NFC("nfc"),
    NOTIFICATIONS("notifications"),
    PAYMENTHANDLER("paymentHandler"),
    PERIODICBACKGROUNDSYNC("periodicBackgroundSync"),
    POINTERLOCK("pointerLock"),
    PROTECTEDMEDIAIDENTIFIER("protectedMediaIdentifier"),
    SENSORS("sensors"),
    SMARTCARD("smartCard"),
    SPEAKERSELECTION("speakerSelection"),
    STORAGEACCESS("storageAccess"),
    TOPLEVELSTORAGEACCESS("topLevelStorageAccess"),
    VIDEOCAPTURE("videoCapture"),
    VR("vr"),
    WAKELOCKSCREEN("wakeLockScreen"),
    WAKELOCKSYSTEM("wakeLockSystem"),
    WEBAPPINSTALLATION("webAppInstallation"),
    WEBPRINTING("webPrinting"),
    WINDOWMANAGEMENT("windowManagement");

    private String value;

    private PermissionType(String value) {
        this.value = value;
    }

    public static PermissionType fromString(String s2) {
        return Arrays.stream(PermissionType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within PermissionType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PermissionType fromJson(JsonInput input) {
        return PermissionType.fromString(input.nextString());
    }
}

