/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.input;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v137.input.model.DragData;
import org.openqa.selenium.devtools.v137.input.model.GestureSourceType;
import org.openqa.selenium.devtools.v137.input.model.MouseButton;
import org.openqa.selenium.devtools.v137.input.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v137.input.model.TouchPoint;
import org.openqa.selenium.json.JsonInput;

public class Input {
    @Beta
    public static Command<Void> dispatchDragEvent(DispatchDragEventType type, Number x, Number y, DragData data, Optional<Integer> modifiers) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(data, "data is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("x", x);
        params.put("y", y);
        params.put("data", data);
        modifiers.ifPresent(p -> params.put("modifiers", p));
        return new Command<Void>("Input.dispatchDragEvent", Map.copyOf(params));
    }

    public static Command<Void> dispatchKeyEvent(DispatchKeyEventType type, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp, Optional<String> text, Optional<String> unmodifiedText, Optional<String> keyIdentifier, Optional<String> code, Optional<String> key, Optional<Integer> windowsVirtualKeyCode, Optional<Integer> nativeVirtualKeyCode, Optional<Boolean> autoRepeat, Optional<Boolean> isKeypad, Optional<Boolean> isSystemKey, Optional<Integer> location, Optional<List<String>> commands) {
        Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, DispatchKeyEventType> params = new LinkedHashMap<String, DispatchKeyEventType>();
        params.put("type", type);
        modifiers.ifPresent(p -> params.put("modifiers", (DispatchKeyEventType)((Object)p)));
        timestamp.ifPresent(p -> params.put("timestamp", (DispatchKeyEventType)((Object)p)));
        text.ifPresent(p -> params.put("text", (DispatchKeyEventType)((Object)p)));
        unmodifiedText.ifPresent(p -> params.put("unmodifiedText", (DispatchKeyEventType)((Object)p)));
        keyIdentifier.ifPresent(p -> params.put("keyIdentifier", (DispatchKeyEventType)((Object)p)));
        code.ifPresent(p -> params.put("code", (DispatchKeyEventType)((Object)p)));
        key.ifPresent(p -> params.put("key", (DispatchKeyEventType)((Object)p)));
        windowsVirtualKeyCode.ifPresent(p -> params.put("windowsVirtualKeyCode", (DispatchKeyEventType)((Object)p)));
        nativeVirtualKeyCode.ifPresent(p -> params.put("nativeVirtualKeyCode", (DispatchKeyEventType)((Object)p)));
        autoRepeat.ifPresent(p -> params.put("autoRepeat", (DispatchKeyEventType)((Object)p)));
        isKeypad.ifPresent(p -> params.put("isKeypad", (DispatchKeyEventType)((Object)p)));
        isSystemKey.ifPresent(p -> params.put("isSystemKey", (DispatchKeyEventType)((Object)p)));
        location.ifPresent(p -> params.put("location", (DispatchKeyEventType)((Object)p)));
        commands.ifPresent(p -> params.put("commands", (DispatchKeyEventType)((Object)p)));
        return new Command<Void>("Input.dispatchKeyEvent", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> insertText(String text) {
        Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("text", text);
        return new Command<Void>("Input.insertText", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> imeSetComposition(String text, Integer selectionStart, Integer selectionEnd, Optional<Integer> replacementStart, Optional<Integer> replacementEnd) {
        Objects.requireNonNull(text, "text is required");
        Objects.requireNonNull(selectionStart, "selectionStart is required");
        Objects.requireNonNull(selectionEnd, "selectionEnd is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("text", text);
        params.put("selectionStart", selectionStart);
        params.put("selectionEnd", selectionEnd);
        replacementStart.ifPresent(p -> params.put("replacementStart", p));
        replacementEnd.ifPresent(p -> params.put("replacementEnd", p));
        return new Command<Void>("Input.imeSetComposition", Map.copyOf(params));
    }

    public static Command<Void> dispatchMouseEvent(DispatchMouseEventType type, Number x, Number y, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp, Optional<MouseButton> button, Optional<Integer> buttons, Optional<Integer> clickCount, Optional<Number> force, Optional<Number> tangentialPressure, Optional<Number> tiltX, Optional<Number> tiltY, Optional<Integer> twist, Optional<Number> deltaX, Optional<Number> deltaY, Optional<DispatchMouseEventPointerType> pointerType) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("x", x);
        params.put("y", y);
        modifiers.ifPresent(p -> params.put("modifiers", p));
        timestamp.ifPresent(p -> params.put("timestamp", p));
        button.ifPresent(p -> params.put("button", p));
        buttons.ifPresent(p -> params.put("buttons", p));
        clickCount.ifPresent(p -> params.put("clickCount", p));
        force.ifPresent(p -> params.put("force", p));
        tangentialPressure.ifPresent(p -> params.put("tangentialPressure", p));
        tiltX.ifPresent(p -> params.put("tiltX", p));
        tiltY.ifPresent(p -> params.put("tiltY", p));
        twist.ifPresent(p -> params.put("twist", p));
        deltaX.ifPresent(p -> params.put("deltaX", p));
        deltaY.ifPresent(p -> params.put("deltaY", p));
        pointerType.ifPresent(p -> params.put("pointerType", p));
        return new Command<Void>("Input.dispatchMouseEvent", Map.copyOf(params));
    }

    public static Command<Void> dispatchTouchEvent(DispatchTouchEventType type, List<TouchPoint> touchPoints, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(touchPoints, "touchPoints is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("touchPoints", touchPoints);
        modifiers.ifPresent(p -> params.put("modifiers", p));
        timestamp.ifPresent(p -> params.put("timestamp", p));
        return new Command<Void>("Input.dispatchTouchEvent", Map.copyOf(params));
    }

    public static Command<Void> cancelDragging() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Input.cancelDragging", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> emulateTouchFromMouseEvent(EmulateTouchFromMouseEventType type, Integer x, Integer y, MouseButton button, Optional<TimeSinceEpoch> timestamp, Optional<Number> deltaX, Optional<Number> deltaY, Optional<Integer> modifiers, Optional<Integer> clickCount) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(button, "button is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("x", x);
        params.put("y", y);
        params.put("button", (Object)button);
        timestamp.ifPresent(p -> params.put("timestamp", p));
        deltaX.ifPresent(p -> params.put("deltaX", p));
        deltaY.ifPresent(p -> params.put("deltaY", p));
        modifiers.ifPresent(p -> params.put("modifiers", p));
        clickCount.ifPresent(p -> params.put("clickCount", p));
        return new Command<Void>("Input.emulateTouchFromMouseEvent", Map.copyOf(params));
    }

    public static Command<Void> setIgnoreInputEvents(Boolean ignore) {
        Objects.requireNonNull(ignore, "ignore is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("ignore", ignore);
        return new Command<Void>("Input.setIgnoreInputEvents", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setInterceptDrags(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("enabled", enabled);
        return new Command<Void>("Input.setInterceptDrags", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> synthesizePinchGesture(Number x, Number y, Number scaleFactor, Optional<Integer> relativeSpeed, Optional<GestureSourceType> gestureSourceType) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(scaleFactor, "scaleFactor is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("x", x);
        params.put("y", y);
        params.put("scaleFactor", scaleFactor);
        relativeSpeed.ifPresent(p -> params.put("relativeSpeed", (Number)p));
        gestureSourceType.ifPresent(p -> params.put("gestureSourceType", (Number)p));
        return new Command<Void>("Input.synthesizePinchGesture", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> synthesizeScrollGesture(Number x, Number y, Optional<Number> xDistance, Optional<Number> yDistance, Optional<Number> xOverscroll, Optional<Number> yOverscroll, Optional<Boolean> preventFling, Optional<Integer> speed, Optional<GestureSourceType> gestureSourceType, Optional<Integer> repeatCount, Optional<Integer> repeatDelayMs, Optional<String> interactionMarkerName) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("x", x);
        params.put("y", y);
        xDistance.ifPresent(p -> params.put("xDistance", (Number)p));
        yDistance.ifPresent(p -> params.put("yDistance", (Number)p));
        xOverscroll.ifPresent(p -> params.put("xOverscroll", (Number)p));
        yOverscroll.ifPresent(p -> params.put("yOverscroll", (Number)p));
        preventFling.ifPresent(p -> params.put("preventFling", (Number)p));
        speed.ifPresent(p -> params.put("speed", (Number)p));
        gestureSourceType.ifPresent(p -> params.put("gestureSourceType", (Number)p));
        repeatCount.ifPresent(p -> params.put("repeatCount", (Number)p));
        repeatDelayMs.ifPresent(p -> params.put("repeatDelayMs", (Number)p));
        interactionMarkerName.ifPresent(p -> params.put("interactionMarkerName", (Number)p));
        return new Command<Void>("Input.synthesizeScrollGesture", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> synthesizeTapGesture(Number x, Number y, Optional<Integer> duration, Optional<Integer> tapCount, Optional<GestureSourceType> gestureSourceType) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        LinkedHashMap<String, Number> params = new LinkedHashMap<String, Number>();
        params.put("x", x);
        params.put("y", y);
        duration.ifPresent(p -> params.put("duration", (Number)p));
        tapCount.ifPresent(p -> params.put("tapCount", (Number)p));
        gestureSourceType.ifPresent(p -> params.put("gestureSourceType", (Number)p));
        return new Command<Void>("Input.synthesizeTapGesture", Map.copyOf(params));
    }

    public static Event<DragData> dragIntercepted() {
        return new Event<DragData>("Input.dragIntercepted", ConverterFunctions.map("data", DragData.class));
    }

    public static enum EmulateTouchFromMouseEventType {
        MOUSEPRESSED("mousePressed"),
        MOUSERELEASED("mouseReleased"),
        MOUSEMOVED("mouseMoved"),
        MOUSEWHEEL("mouseWheel");

        private String value;

        private EmulateTouchFromMouseEventType(String value) {
            this.value = value;
        }

        public static EmulateTouchFromMouseEventType fromString(String s2) {
            return Arrays.stream(EmulateTouchFromMouseEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within EmulateTouchFromMouseEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EmulateTouchFromMouseEventType fromJson(JsonInput input) {
            return EmulateTouchFromMouseEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchTouchEventType {
        TOUCHSTART("touchStart"),
        TOUCHEND("touchEnd"),
        TOUCHMOVE("touchMove"),
        TOUCHCANCEL("touchCancel");

        private String value;

        private DispatchTouchEventType(String value) {
            this.value = value;
        }

        public static DispatchTouchEventType fromString(String s2) {
            return Arrays.stream(DispatchTouchEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DispatchTouchEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchTouchEventType fromJson(JsonInput input) {
            return DispatchTouchEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchMouseEventPointerType {
        MOUSE("mouse"),
        PEN("pen");

        private String value;

        private DispatchMouseEventPointerType(String value) {
            this.value = value;
        }

        public static DispatchMouseEventPointerType fromString(String s2) {
            return Arrays.stream(DispatchMouseEventPointerType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DispatchMouseEventPointerType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchMouseEventPointerType fromJson(JsonInput input) {
            return DispatchMouseEventPointerType.fromString(input.nextString());
        }
    }

    public static enum DispatchMouseEventType {
        MOUSEPRESSED("mousePressed"),
        MOUSERELEASED("mouseReleased"),
        MOUSEMOVED("mouseMoved"),
        MOUSEWHEEL("mouseWheel");

        private String value;

        private DispatchMouseEventType(String value) {
            this.value = value;
        }

        public static DispatchMouseEventType fromString(String s2) {
            return Arrays.stream(DispatchMouseEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DispatchMouseEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchMouseEventType fromJson(JsonInput input) {
            return DispatchMouseEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchKeyEventType {
        KEYDOWN("keyDown"),
        KEYUP("keyUp"),
        RAWKEYDOWN("rawKeyDown"),
        CHAR("char");

        private String value;

        private DispatchKeyEventType(String value) {
            this.value = value;
        }

        public static DispatchKeyEventType fromString(String s2) {
            return Arrays.stream(DispatchKeyEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DispatchKeyEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchKeyEventType fromJson(JsonInput input) {
            return DispatchKeyEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchDragEventType {
        DRAGENTER("dragEnter"),
        DRAGOVER("dragOver"),
        DROP("drop"),
        DRAGCANCEL("dragCancel");

        private String value;

        private DispatchDragEventType(String value) {
            this.value = value;
        }

        public static DispatchDragEventType fromString(String s2) {
            return Arrays.stream(DispatchDragEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DispatchDragEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchDragEventType fromJson(JsonInput input) {
            return DispatchDragEventType.fromString(input.nextString());
        }
    }
}

