/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.overlay;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v137.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v137.dom.model.NodeId;
import org.openqa.selenium.devtools.v137.dom.model.Quad;
import org.openqa.selenium.devtools.v137.dom.model.RGBA;
import org.openqa.selenium.devtools.v137.overlay.model.ColorFormat;
import org.openqa.selenium.devtools.v137.overlay.model.ContainerQueryHighlightConfig;
import org.openqa.selenium.devtools.v137.overlay.model.FlexNodeHighlightConfig;
import org.openqa.selenium.devtools.v137.overlay.model.GridNodeHighlightConfig;
import org.openqa.selenium.devtools.v137.overlay.model.HighlightConfig;
import org.openqa.selenium.devtools.v137.overlay.model.HingeConfig;
import org.openqa.selenium.devtools.v137.overlay.model.InspectMode;
import org.openqa.selenium.devtools.v137.overlay.model.IsolatedElementHighlightConfig;
import org.openqa.selenium.devtools.v137.overlay.model.ScrollSnapHighlightConfig;
import org.openqa.selenium.devtools.v137.overlay.model.SourceOrderConfig;
import org.openqa.selenium.devtools.v137.overlay.model.WindowControlsOverlayConfig;
import org.openqa.selenium.devtools.v137.page.model.FrameId;
import org.openqa.selenium.devtools.v137.page.model.Viewport;
import org.openqa.selenium.devtools.v137.runtime.model.RemoteObjectId;

@Beta
public class Overlay {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Overlay.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Overlay.enable", Map.copyOf(params));
    }

    public static Command<Map<String, Object>> getHighlightObjectForTest(NodeId nodeId, Optional<Boolean> includeDistance, Optional<Boolean> includeStyle, Optional<ColorFormat> colorFormat, Optional<Boolean> showAccessibilityInfo) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        includeDistance.ifPresent(p -> params.put("includeDistance", (NodeId)p));
        includeStyle.ifPresent(p -> params.put("includeStyle", (NodeId)p));
        colorFormat.ifPresent(p -> params.put("colorFormat", (NodeId)p));
        showAccessibilityInfo.ifPresent(p -> params.put("showAccessibilityInfo", (NodeId)p));
        return new Command<Map<String, Object>>("Overlay.getHighlightObjectForTest", Map.copyOf(params), ConverterFunctions.map("highlight", Map.class));
    }

    public static Command<Map<String, Object>> getGridHighlightObjectsForTest(List<NodeId> nodeIds) {
        Objects.requireNonNull(nodeIds, "nodeIds is required");
        LinkedHashMap<String, List<NodeId>> params = new LinkedHashMap<String, List<NodeId>>();
        params.put("nodeIds", nodeIds);
        return new Command<Map<String, Object>>("Overlay.getGridHighlightObjectsForTest", Map.copyOf(params), ConverterFunctions.map("highlights", Map.class));
    }

    public static Command<Map<String, Object>> getSourceOrderHighlightObjectForTest(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, NodeId> params = new LinkedHashMap<String, NodeId>();
        params.put("nodeId", nodeId);
        return new Command<Map<String, Object>>("Overlay.getSourceOrderHighlightObjectForTest", Map.copyOf(params), ConverterFunctions.map("highlight", Map.class));
    }

    public static Command<Void> hideHighlight() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Overlay.hideHighlight", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> highlightFrame(FrameId frameId, Optional<RGBA> contentColor, Optional<RGBA> contentOutlineColor) {
        Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, FrameId> params = new LinkedHashMap<String, FrameId>();
        params.put("frameId", frameId);
        contentColor.ifPresent(p -> params.put("contentColor", (FrameId)p));
        contentOutlineColor.ifPresent(p -> params.put("contentOutlineColor", (FrameId)p));
        return new Command<Void>("Overlay.highlightFrame", Map.copyOf(params));
    }

    public static Command<Void> highlightNode(HighlightConfig highlightConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> selector) {
        Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        LinkedHashMap<String, HighlightConfig> params = new LinkedHashMap<String, HighlightConfig>();
        params.put("highlightConfig", highlightConfig);
        nodeId.ifPresent(p -> params.put("nodeId", (HighlightConfig)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (HighlightConfig)p));
        objectId.ifPresent(p -> params.put("objectId", (HighlightConfig)p));
        selector.ifPresent(p -> params.put("selector", (HighlightConfig)p));
        return new Command<Void>("Overlay.highlightNode", Map.copyOf(params));
    }

    public static Command<Void> highlightQuad(Quad quad, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(quad, "quad is required");
        LinkedHashMap<String, Quad> params = new LinkedHashMap<String, Quad>();
        params.put("quad", quad);
        color.ifPresent(p -> params.put("color", (Quad)p));
        outlineColor.ifPresent(p -> params.put("outlineColor", (Quad)p));
        return new Command<Void>("Overlay.highlightQuad", Map.copyOf(params));
    }

    public static Command<Void> highlightRect(Integer x, Integer y, Integer width, Integer height, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("x", x);
        params.put("y", y);
        params.put("width", width);
        params.put("height", height);
        color.ifPresent(p -> params.put("color", (Integer)p));
        outlineColor.ifPresent(p -> params.put("outlineColor", (Integer)p));
        return new Command<Void>("Overlay.highlightRect", Map.copyOf(params));
    }

    public static Command<Void> highlightSourceOrder(SourceOrderConfig sourceOrderConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(sourceOrderConfig, "sourceOrderConfig is required");
        LinkedHashMap<String, SourceOrderConfig> params = new LinkedHashMap<String, SourceOrderConfig>();
        params.put("sourceOrderConfig", sourceOrderConfig);
        nodeId.ifPresent(p -> params.put("nodeId", (SourceOrderConfig)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (SourceOrderConfig)p));
        objectId.ifPresent(p -> params.put("objectId", (SourceOrderConfig)p));
        return new Command<Void>("Overlay.highlightSourceOrder", Map.copyOf(params));
    }

    public static Command<Void> setInspectMode(InspectMode mode, Optional<HighlightConfig> highlightConfig) {
        Objects.requireNonNull(mode, "mode is required");
        LinkedHashMap<String, InspectMode> params = new LinkedHashMap<String, InspectMode>();
        params.put("mode", mode);
        highlightConfig.ifPresent(p -> params.put("highlightConfig", (InspectMode)((Object)p)));
        return new Command<Void>("Overlay.setInspectMode", Map.copyOf(params));
    }

    public static Command<Void> setShowAdHighlights(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowAdHighlights", Map.copyOf(params));
    }

    public static Command<Void> setPausedInDebuggerMessage(Optional<String> message) {
        LinkedHashMap params = new LinkedHashMap();
        message.ifPresent(p -> params.put("message", p));
        return new Command<Void>("Overlay.setPausedInDebuggerMessage", Map.copyOf(params));
    }

    public static Command<Void> setShowDebugBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowDebugBorders", Map.copyOf(params));
    }

    public static Command<Void> setShowFPSCounter(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowFPSCounter", Map.copyOf(params));
    }

    public static Command<Void> setShowGridOverlays(List<GridNodeHighlightConfig> gridNodeHighlightConfigs) {
        Objects.requireNonNull(gridNodeHighlightConfigs, "gridNodeHighlightConfigs is required");
        LinkedHashMap<String, List<GridNodeHighlightConfig>> params = new LinkedHashMap<String, List<GridNodeHighlightConfig>>();
        params.put("gridNodeHighlightConfigs", gridNodeHighlightConfigs);
        return new Command<Void>("Overlay.setShowGridOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowFlexOverlays(List<FlexNodeHighlightConfig> flexNodeHighlightConfigs) {
        Objects.requireNonNull(flexNodeHighlightConfigs, "flexNodeHighlightConfigs is required");
        LinkedHashMap<String, List<FlexNodeHighlightConfig>> params = new LinkedHashMap<String, List<FlexNodeHighlightConfig>>();
        params.put("flexNodeHighlightConfigs", flexNodeHighlightConfigs);
        return new Command<Void>("Overlay.setShowFlexOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowScrollSnapOverlays(List<ScrollSnapHighlightConfig> scrollSnapHighlightConfigs) {
        Objects.requireNonNull(scrollSnapHighlightConfigs, "scrollSnapHighlightConfigs is required");
        LinkedHashMap<String, List<ScrollSnapHighlightConfig>> params = new LinkedHashMap<String, List<ScrollSnapHighlightConfig>>();
        params.put("scrollSnapHighlightConfigs", scrollSnapHighlightConfigs);
        return new Command<Void>("Overlay.setShowScrollSnapOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowContainerQueryOverlays(List<ContainerQueryHighlightConfig> containerQueryHighlightConfigs) {
        Objects.requireNonNull(containerQueryHighlightConfigs, "containerQueryHighlightConfigs is required");
        LinkedHashMap<String, List<ContainerQueryHighlightConfig>> params = new LinkedHashMap<String, List<ContainerQueryHighlightConfig>>();
        params.put("containerQueryHighlightConfigs", containerQueryHighlightConfigs);
        return new Command<Void>("Overlay.setShowContainerQueryOverlays", Map.copyOf(params));
    }

    public static Command<Void> setShowPaintRects(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("result", result);
        return new Command<Void>("Overlay.setShowPaintRects", Map.copyOf(params));
    }

    public static Command<Void> setShowLayoutShiftRegions(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("result", result);
        return new Command<Void>("Overlay.setShowLayoutShiftRegions", Map.copyOf(params));
    }

    public static Command<Void> setShowScrollBottleneckRects(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowScrollBottleneckRects", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> setShowHitTestBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowHitTestBorders", Map.copyOf(params));
    }

    @Deprecated
    public static Command<Void> setShowWebVitals(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowWebVitals", Map.copyOf(params));
    }

    public static Command<Void> setShowViewportSizeOnResize(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowViewportSizeOnResize", Map.copyOf(params));
    }

    public static Command<Void> setShowHinge(Optional<HingeConfig> hingeConfig) {
        LinkedHashMap params = new LinkedHashMap();
        hingeConfig.ifPresent(p -> params.put("hingeConfig", p));
        return new Command<Void>("Overlay.setShowHinge", Map.copyOf(params));
    }

    public static Command<Void> setShowIsolatedElements(List<IsolatedElementHighlightConfig> isolatedElementHighlightConfigs) {
        Objects.requireNonNull(isolatedElementHighlightConfigs, "isolatedElementHighlightConfigs is required");
        LinkedHashMap<String, List<IsolatedElementHighlightConfig>> params = new LinkedHashMap<String, List<IsolatedElementHighlightConfig>>();
        params.put("isolatedElementHighlightConfigs", isolatedElementHighlightConfigs);
        return new Command<Void>("Overlay.setShowIsolatedElements", Map.copyOf(params));
    }

    public static Command<Void> setShowWindowControlsOverlay(Optional<WindowControlsOverlayConfig> windowControlsOverlayConfig) {
        LinkedHashMap params = new LinkedHashMap();
        windowControlsOverlayConfig.ifPresent(p -> params.put("windowControlsOverlayConfig", p));
        return new Command<Void>("Overlay.setShowWindowControlsOverlay", Map.copyOf(params));
    }

    public static Event<BackendNodeId> inspectNodeRequested() {
        return new Event<BackendNodeId>("Overlay.inspectNodeRequested", ConverterFunctions.map("backendNodeId", BackendNodeId.class));
    }

    public static Event<NodeId> nodeHighlightRequested() {
        return new Event<NodeId>("Overlay.nodeHighlightRequested", ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Event<Viewport> screenshotRequested() {
        return new Event<Viewport>("Overlay.screenshotRequested", ConverterFunctions.map("viewport", Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event<Void>("Overlay.inspectModeCanceled", ConverterFunctions.empty());
    }
}

