/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.webauthn.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v137.webauthn.model.AuthenticatorId;
import org.openqa.selenium.devtools.v137.webauthn.model.Credential;
import org.openqa.selenium.json.JsonInput;

public class CredentialUpdated {
    private final AuthenticatorId authenticatorId;
    private final Credential credential;

    public CredentialUpdated(AuthenticatorId authenticatorId, Credential credential) {
        this.authenticatorId = Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        this.credential = Objects.requireNonNull(credential, "credential is required");
    }

    public AuthenticatorId getAuthenticatorId() {
        return this.authenticatorId;
    }

    public Credential getCredential() {
        return this.credential;
    }

    private static CredentialUpdated fromJson(JsonInput input) {
        AuthenticatorId authenticatorId = null;
        Credential credential = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "authenticatorId": {
                    authenticatorId = (AuthenticatorId)input.read((Type)((Object)AuthenticatorId.class));
                    continue block8;
                }
                case "credential": {
                    credential = (Credential)input.read((Type)((Object)Credential.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CredentialUpdated(authenticatorId, credential);
    }
}

