/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.bluetoothemulation.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v138.bluetoothemulation.model.DescriptorOperationType;
import org.openqa.selenium.json.JsonInput;

public class DescriptorOperationReceived {
    private final String descriptorId;
    private final DescriptorOperationType type;
    private final Optional<String> data;

    public DescriptorOperationReceived(String descriptorId, DescriptorOperationType type, Optional<String> data) {
        this.descriptorId = Objects.requireNonNull(descriptorId, "descriptorId is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.data = data;
    }

    public String getDescriptorId() {
        return this.descriptorId;
    }

    public DescriptorOperationType getType() {
        return this.type;
    }

    public Optional<String> getData() {
        return this.data;
    }

    private static DescriptorOperationReceived fromJson(JsonInput input) {
        String descriptorId = null;
        DescriptorOperationType type = null;
        Optional<String> data = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "descriptorId": {
                    descriptorId = input.nextString();
                    continue block10;
                }
                case "type": {
                    type = (DescriptorOperationType)((Object)input.read((Type)((Object)DescriptorOperationType.class)));
                    continue block10;
                }
                case "data": {
                    data = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DescriptorOperationReceived(descriptorId, type, data);
    }
}

