/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.css.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v138.css.model.CSSFunctionNode;
import org.openqa.selenium.devtools.v138.css.model.CSSFunctionParameter;
import org.openqa.selenium.devtools.v138.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v138.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v138.css.model.Value;
import org.openqa.selenium.json.JsonInput;

public class CSSFunctionRule {
    private final Value name;
    private final Optional<StyleSheetId> styleSheetId;
    private final StyleSheetOrigin origin;
    private final List<CSSFunctionParameter> parameters;
    private final List<CSSFunctionNode> children;

    public CSSFunctionRule(Value name, Optional<StyleSheetId> styleSheetId, StyleSheetOrigin origin, List<CSSFunctionParameter> parameters, List<CSSFunctionNode> children) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.styleSheetId = styleSheetId;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.parameters = Objects.requireNonNull(parameters, "parameters is required");
        this.children = Objects.requireNonNull(children, "children is required");
    }

    public Value getName() {
        return this.name;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public List<CSSFunctionParameter> getParameters() {
        return this.parameters;
    }

    public List<CSSFunctionNode> getChildren() {
        return this.children;
    }

    private static CSSFunctionRule fromJson(JsonInput input) {
        Value name = null;
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        StyleSheetOrigin origin = null;
        List parameters = null;
        List children = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = (Value)input.read((Type)((Object)Value.class));
                    continue block14;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read((Type)((Object)StyleSheetId.class)));
                    continue block14;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read((Type)((Object)StyleSheetOrigin.class)));
                    continue block14;
                }
                case "parameters": {
                    parameters = input.readArray((Type)((Object)CSSFunctionParameter.class));
                    continue block14;
                }
                case "children": {
                    children = input.readArray((Type)((Object)CSSFunctionNode.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSFunctionRule(name, styleSheetId, origin, parameters, children);
    }
}

