/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.layertree;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v138.dom.model.Rect;
import org.openqa.selenium.devtools.v138.layertree.model.Layer;
import org.openqa.selenium.devtools.v138.layertree.model.LayerId;
import org.openqa.selenium.devtools.v138.layertree.model.LayerPainted;
import org.openqa.selenium.devtools.v138.layertree.model.PaintProfile;
import org.openqa.selenium.devtools.v138.layertree.model.PictureTile;
import org.openqa.selenium.devtools.v138.layertree.model.SnapshotId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LayerTree {
    public static Command<CompositingReasonsResponse> compositingReasons(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        LinkedHashMap<String, LayerId> params = new LinkedHashMap<String, LayerId>();
        params.put("layerId", layerId);
        return new Command<CompositingReasonsResponse>("LayerTree.compositingReasons", Map.copyOf(params), input -> (CompositingReasonsResponse)input.read((Type)((Object)CompositingReasonsResponse.class)));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("LayerTree.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("LayerTree.enable", Map.copyOf(params));
    }

    public static Command<SnapshotId> loadSnapshot(List<PictureTile> tiles) {
        Objects.requireNonNull(tiles, "tiles is required");
        LinkedHashMap<String, List<PictureTile>> params = new LinkedHashMap<String, List<PictureTile>>();
        params.put("tiles", tiles);
        return new Command<SnapshotId>("LayerTree.loadSnapshot", Map.copyOf(params), ConverterFunctions.map("snapshotId", SnapshotId.class));
    }

    public static Command<SnapshotId> makeSnapshot(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        LinkedHashMap<String, LayerId> params = new LinkedHashMap<String, LayerId>();
        params.put("layerId", layerId);
        return new Command<SnapshotId>("LayerTree.makeSnapshot", Map.copyOf(params), ConverterFunctions.map("snapshotId", SnapshotId.class));
    }

    public static Command<List<PaintProfile>> profileSnapshot(SnapshotId snapshotId, Optional<Integer> minRepeatCount, Optional<Number> minDuration, Optional<Rect> clipRect) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        minRepeatCount.ifPresent(p -> params.put("minRepeatCount", (SnapshotId)p));
        minDuration.ifPresent(p -> params.put("minDuration", (SnapshotId)p));
        clipRect.ifPresent(p -> params.put("clipRect", (SnapshotId)p));
        return new Command<List<PaintProfile>>("LayerTree.profileSnapshot", Map.copyOf(params), ConverterFunctions.map("timings", input -> input.readArray((Type)((Object)PaintProfile.class))));
    }

    public static Command<Void> releaseSnapshot(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        return new Command<Void>("LayerTree.releaseSnapshot", Map.copyOf(params));
    }

    public static Command<String> replaySnapshot(SnapshotId snapshotId, Optional<Integer> fromStep, Optional<Integer> toStep, Optional<Number> scale) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        fromStep.ifPresent(p -> params.put("fromStep", (SnapshotId)p));
        toStep.ifPresent(p -> params.put("toStep", (SnapshotId)p));
        scale.ifPresent(p -> params.put("scale", (SnapshotId)p));
        return new Command<String>("LayerTree.replaySnapshot", Map.copyOf(params), ConverterFunctions.map("dataURL", String.class));
    }

    public static Command<List<Map<String, Object>>> snapshotCommandLog(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        return new Command<List<Map<String, Object>>>("LayerTree.snapshotCommandLog", Map.copyOf(params), ConverterFunctions.map("commandLog", input -> input.readArray((Type)((Object)Map.class))));
    }

    public static Event<LayerPainted> layerPainted() {
        return new Event<LayerPainted>("LayerTree.layerPainted", input -> (LayerPainted)input.read((Type)((Object)LayerPainted.class)));
    }

    public static Event<List<Layer>> layerTreeDidChange() {
        return new Event<List<Layer>>("LayerTree.layerTreeDidChange", ConverterFunctions.map("layers", input -> input.readArray((Type)((Object)Layer.class))));
    }

    public static class CompositingReasonsResponse {
        private final List<String> compositingReasons;
        private final List<String> compositingReasonIds;

        public CompositingReasonsResponse(List<String> compositingReasons, List<String> compositingReasonIds) {
            this.compositingReasons = Objects.requireNonNull(compositingReasons, "compositingReasons is required");
            this.compositingReasonIds = Objects.requireNonNull(compositingReasonIds, "compositingReasonIds is required");
        }

        public List<String> getCompositingReasons() {
            return this.compositingReasons;
        }

        public List<String> getCompositingReasonIds() {
            return this.compositingReasonIds;
        }

        private static CompositingReasonsResponse fromJson(JsonInput input) {
            List compositingReasons = null;
            List compositingReasonIds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "compositingReasons": {
                        compositingReasons = input.readArray((Type)((Object)String.class));
                        continue block8;
                    }
                    case "compositingReasonIds": {
                        compositingReasonIds = input.readArray((Type)((Object)String.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompositingReasonsResponse(compositingReasons, compositingReasonIds);
        }
    }
}

