/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v138.network.model.DirectUDPSocketOptions;
import org.openqa.selenium.devtools.v138.network.model.Initiator;
import org.openqa.selenium.devtools.v138.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v138.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectUDPSocketCreated {
    private final RequestId identifier;
    private final DirectUDPSocketOptions options;
    private final MonotonicTime timestamp;
    private final Optional<Initiator> initiator;

    public DirectUDPSocketCreated(RequestId identifier, DirectUDPSocketOptions options, MonotonicTime timestamp, Optional<Initiator> initiator) {
        this.identifier = Objects.requireNonNull(identifier, "identifier is required");
        this.options = Objects.requireNonNull(options, "options is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.initiator = initiator;
    }

    public RequestId getIdentifier() {
        return this.identifier;
    }

    public DirectUDPSocketOptions getOptions() {
        return this.options;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Optional<Initiator> getInitiator() {
        return this.initiator;
    }

    private static DirectUDPSocketCreated fromJson(JsonInput input) {
        RequestId identifier = null;
        DirectUDPSocketOptions options = null;
        MonotonicTime timestamp = null;
        Optional<Initiator> initiator = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "identifier": {
                    identifier = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block12;
                }
                case "options": {
                    options = (DirectUDPSocketOptions)input.read((Type)((Object)DirectUDPSocketOptions.class));
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read((Type)((Object)MonotonicTime.class));
                    continue block12;
                }
                case "initiator": {
                    initiator = Optional.ofNullable((Initiator)input.read((Type)((Object)Initiator.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectUDPSocketCreated(identifier, options, timestamp, initiator);
    }
}

