/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.page.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v138.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v138.page.model.OriginTrialUsageRestriction;
import org.openqa.selenium.json.JsonInput;

@Beta
public class OriginTrialToken {
    private final String origin;
    private final Boolean matchSubDomains;
    private final String trialName;
    private final TimeSinceEpoch expiryTime;
    private final Boolean isThirdParty;
    private final OriginTrialUsageRestriction usageRestriction;

    public OriginTrialToken(String origin, Boolean matchSubDomains, String trialName, TimeSinceEpoch expiryTime, Boolean isThirdParty, OriginTrialUsageRestriction usageRestriction) {
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.matchSubDomains = Objects.requireNonNull(matchSubDomains, "matchSubDomains is required");
        this.trialName = Objects.requireNonNull(trialName, "trialName is required");
        this.expiryTime = Objects.requireNonNull(expiryTime, "expiryTime is required");
        this.isThirdParty = Objects.requireNonNull(isThirdParty, "isThirdParty is required");
        this.usageRestriction = Objects.requireNonNull(usageRestriction, "usageRestriction is required");
    }

    public String getOrigin() {
        return this.origin;
    }

    public Boolean getMatchSubDomains() {
        return this.matchSubDomains;
    }

    public String getTrialName() {
        return this.trialName;
    }

    public TimeSinceEpoch getExpiryTime() {
        return this.expiryTime;
    }

    public Boolean getIsThirdParty() {
        return this.isThirdParty;
    }

    public OriginTrialUsageRestriction getUsageRestriction() {
        return this.usageRestriction;
    }

    private static OriginTrialToken fromJson(JsonInput input) {
        String origin = null;
        Boolean matchSubDomains = false;
        String trialName = null;
        TimeSinceEpoch expiryTime = null;
        Boolean isThirdParty = false;
        OriginTrialUsageRestriction usageRestriction = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "origin": {
                    origin = input.nextString();
                    continue block16;
                }
                case "matchSubDomains": {
                    matchSubDomains = input.nextBoolean();
                    continue block16;
                }
                case "trialName": {
                    trialName = input.nextString();
                    continue block16;
                }
                case "expiryTime": {
                    expiryTime = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block16;
                }
                case "isThirdParty": {
                    isThirdParty = input.nextBoolean();
                    continue block16;
                }
                case "usageRestriction": {
                    usageRestriction = (OriginTrialUsageRestriction)((Object)input.read((Type)((Object)OriginTrialUsageRestriction.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new OriginTrialToken(origin, matchSubDomains, trialName, expiryTime, isThirdParty, usageRestriction);
    }
}

