/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.performancetimeline.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v138.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v138.dom.model.Rect;
import org.openqa.selenium.json.JsonInput;

public class LayoutShiftAttribution {
    private final Rect previousRect;
    private final Rect currentRect;
    private final Optional<BackendNodeId> nodeId;

    public LayoutShiftAttribution(Rect previousRect, Rect currentRect, Optional<BackendNodeId> nodeId) {
        this.previousRect = Objects.requireNonNull(previousRect, "previousRect is required");
        this.currentRect = Objects.requireNonNull(currentRect, "currentRect is required");
        this.nodeId = nodeId;
    }

    public Rect getPreviousRect() {
        return this.previousRect;
    }

    public Rect getCurrentRect() {
        return this.currentRect;
    }

    public Optional<BackendNodeId> getNodeId() {
        return this.nodeId;
    }

    private static LayoutShiftAttribution fromJson(JsonInput input) {
        Rect previousRect = null;
        Rect currentRect = null;
        Optional<BackendNodeId> nodeId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "previousRect": {
                    previousRect = (Rect)input.read((Type)((Object)Rect.class));
                    continue block10;
                }
                case "currentRect": {
                    currentRect = (Rect)input.read((Type)((Object)Rect.class));
                    continue block10;
                }
                case "nodeId": {
                    nodeId = Optional.ofNullable((BackendNodeId)input.read((Type)((Object)BackendNodeId.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutShiftAttribution(previousRect, currentRect, nodeId);
    }
}

