/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.pwa.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum DisplayMode {
    STANDALONE("standalone"),
    BROWSER("browser");

    private String value;

    private DisplayMode(String value) {
        this.value = value;
    }

    public static DisplayMode fromString(String s2) {
        return Arrays.stream(DisplayMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DisplayMode "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static DisplayMode fromJson(JsonInput input) {
        return DisplayMode.fromString(input.nextString());
    }
}

