/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.serviceworker;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v138.serviceworker.model.RegistrationID;
import org.openqa.selenium.devtools.v138.serviceworker.model.ServiceWorkerErrorMessage;
import org.openqa.selenium.devtools.v138.serviceworker.model.ServiceWorkerRegistration;
import org.openqa.selenium.devtools.v138.serviceworker.model.ServiceWorkerVersion;

@Beta
public class ServiceWorker {
    public static Command<Void> deliverPushMessage(String origin, RegistrationID registrationId, String data) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(data, "data is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("data", data);
        return new Command<Void>("ServiceWorker.deliverPushMessage", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("ServiceWorker.disable", Map.copyOf(params));
    }

    public static Command<Void> dispatchSyncEvent(String origin, RegistrationID registrationId, String tag, Boolean lastChance) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(tag, "tag is required");
        Objects.requireNonNull(lastChance, "lastChance is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("tag", tag);
        params.put("lastChance", lastChance);
        return new Command<Void>("ServiceWorker.dispatchSyncEvent", Map.copyOf(params));
    }

    public static Command<Void> dispatchPeriodicSyncEvent(String origin, RegistrationID registrationId, String tag) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(tag, "tag is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("tag", tag);
        return new Command<Void>("ServiceWorker.dispatchPeriodicSyncEvent", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("ServiceWorker.enable", Map.copyOf(params));
    }

    public static Command<Void> inspectWorker(String versionId) {
        Objects.requireNonNull(versionId, "versionId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("versionId", versionId);
        return new Command<Void>("ServiceWorker.inspectWorker", Map.copyOf(params));
    }

    public static Command<Void> setForceUpdateOnPageLoad(Boolean forceUpdateOnPageLoad) {
        Objects.requireNonNull(forceUpdateOnPageLoad, "forceUpdateOnPageLoad is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("forceUpdateOnPageLoad", forceUpdateOnPageLoad);
        return new Command<Void>("ServiceWorker.setForceUpdateOnPageLoad", Map.copyOf(params));
    }

    public static Command<Void> skipWaiting(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.skipWaiting", Map.copyOf(params));
    }

    public static Command<Void> startWorker(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.startWorker", Map.copyOf(params));
    }

    public static Command<Void> stopAllWorkers() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("ServiceWorker.stopAllWorkers", Map.copyOf(params));
    }

    public static Command<Void> stopWorker(String versionId) {
        Objects.requireNonNull(versionId, "versionId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("versionId", versionId);
        return new Command<Void>("ServiceWorker.stopWorker", Map.copyOf(params));
    }

    public static Command<Void> unregister(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.unregister", Map.copyOf(params));
    }

    public static Command<Void> updateRegistration(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.updateRegistration", Map.copyOf(params));
    }

    public static Event<ServiceWorkerErrorMessage> workerErrorReported() {
        return new Event<ServiceWorkerErrorMessage>("ServiceWorker.workerErrorReported", ConverterFunctions.map("errorMessage", ServiceWorkerErrorMessage.class));
    }

    public static Event<List<ServiceWorkerRegistration>> workerRegistrationUpdated() {
        return new Event<List<ServiceWorkerRegistration>>("ServiceWorker.workerRegistrationUpdated", ConverterFunctions.map("registrations", input -> input.readArray((Type)((Object)ServiceWorkerRegistration.class))));
    }

    public static Event<List<ServiceWorkerVersion>> workerVersionUpdated() {
        return new Event<List<ServiceWorkerVersion>>("ServiceWorker.workerVersionUpdated", ConverterFunctions.map("versions", input -> input.readArray((Type)((Object)ServiceWorkerVersion.class))));
    }
}

