/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.audits;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v139.audits.model.GenericIssueDetails;
import org.openqa.selenium.devtools.v139.audits.model.InspectorIssue;
import org.openqa.selenium.devtools.v139.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Audits {
    public static Command<GetEncodedResponseResponse> getEncodedResponse(RequestId requestId, GetEncodedResponseEncoding encoding, Optional<Number> quality, Optional<Boolean> sizeOnly) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(encoding, "encoding is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("encoding", (Object)encoding);
        quality.ifPresent(p -> params.put("quality", p));
        sizeOnly.ifPresent(p -> params.put("sizeOnly", p));
        return new Command<GetEncodedResponseResponse>("Audits.getEncodedResponse", Map.copyOf(params), input -> (GetEncodedResponseResponse)input.read((Type)((Object)GetEncodedResponseResponse.class)));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Audits.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Audits.enable", Map.copyOf(params));
    }

    public static Command<Void> checkContrast(Optional<Boolean> reportAAA) {
        LinkedHashMap params = new LinkedHashMap();
        reportAAA.ifPresent(p -> params.put("reportAAA", p));
        return new Command<Void>("Audits.checkContrast", Map.copyOf(params));
    }

    public static Command<List<GenericIssueDetails>> checkFormsIssues() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<GenericIssueDetails>>("Audits.checkFormsIssues", Map.copyOf(params), ConverterFunctions.map("formIssues", input -> input.readArray((Type)((Object)GenericIssueDetails.class))));
    }

    public static Event<InspectorIssue> issueAdded() {
        return new Event<InspectorIssue>("Audits.issueAdded", ConverterFunctions.map("issue", InspectorIssue.class));
    }

    public static class GetEncodedResponseResponse {
        private final Optional<String> body;
        private final Integer originalSize;
        private final Integer encodedSize;

        public GetEncodedResponseResponse(Optional<String> body2, Integer originalSize, Integer encodedSize) {
            this.body = body2;
            this.originalSize = Objects.requireNonNull(originalSize, "originalSize is required");
            this.encodedSize = Objects.requireNonNull(encodedSize, "encodedSize is required");
        }

        public Optional<String> getBody() {
            return this.body;
        }

        public Integer getOriginalSize() {
            return this.originalSize;
        }

        public Integer getEncodedSize() {
            return this.encodedSize;
        }

        private static GetEncodedResponseResponse fromJson(JsonInput input) {
            Optional<String> body2 = Optional.empty();
            Integer originalSize = 0;
            Integer encodedSize = 0;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body2 = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                    case "originalSize": {
                        originalSize = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "encodedSize": {
                        encodedSize = input.nextNumber().intValue();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetEncodedResponseResponse(body2, originalSize, encodedSize);
        }
    }

    public static enum GetEncodedResponseEncoding {
        WEBP("webp"),
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private GetEncodedResponseEncoding(String value) {
            this.value = value;
        }

        public static GetEncodedResponseEncoding fromString(String s2) {
            return Arrays.stream(GetEncodedResponseEncoding.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within GetEncodedResponseEncoding "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static GetEncodedResponseEncoding fromJson(JsonInput input) {
            return GetEncodedResponseEncoding.fromString(input.nextString());
        }
    }
}

