/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum InsightType {
    GITHUBRESOURCE("GitHubResource"),
    GRACEPERIOD("GracePeriod"),
    HEURISTICS("Heuristics");

    private String value;

    private InsightType(String value) {
        this.value = value;
    }

    public static InsightType fromString(String s2) {
        return Arrays.stream(InsightType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within InsightType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static InsightType fromJson(JsonInput input) {
        return InsightType.fromString(input.nextString());
    }
}

