/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.css.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum CSSRuleType {
    MEDIARULE("MediaRule"),
    SUPPORTSRULE("SupportsRule"),
    CONTAINERRULE("ContainerRule"),
    LAYERRULE("LayerRule"),
    SCOPERULE("ScopeRule"),
    STYLERULE("StyleRule"),
    STARTINGSTYLERULE("StartingStyleRule");

    private String value;

    private CSSRuleType(String value) {
        this.value = value;
    }

    public static CSSRuleType fromString(String s2) {
        return Arrays.stream(CSSRuleType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CSSRuleType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CSSRuleType fromJson(JsonInput input) {
        return CSSRuleType.fromString(input.nextString());
    }
}

