/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.network.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v139.network.model.Cookie;
import org.openqa.selenium.devtools.v139.network.model.CookieBlockedReason;
import org.openqa.selenium.devtools.v139.network.model.CookieExemptionReason;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AssociatedCookie {
    private final Cookie cookie;
    private final List<CookieBlockedReason> blockedReasons;
    private final Optional<CookieExemptionReason> exemptionReason;

    public AssociatedCookie(Cookie cookie, List<CookieBlockedReason> blockedReasons, Optional<CookieExemptionReason> exemptionReason) {
        this.cookie = Objects.requireNonNull(cookie, "cookie is required");
        this.blockedReasons = Objects.requireNonNull(blockedReasons, "blockedReasons is required");
        this.exemptionReason = exemptionReason;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public List<CookieBlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    public Optional<CookieExemptionReason> getExemptionReason() {
        return this.exemptionReason;
    }

    private static AssociatedCookie fromJson(JsonInput input) {
        Cookie cookie = null;
        List blockedReasons = null;
        Optional<CookieExemptionReason> exemptionReason = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "cookie": {
                    cookie = (Cookie)input.read((Type)((Object)Cookie.class));
                    continue block10;
                }
                case "blockedReasons": {
                    blockedReasons = input.readArray((Type)((Object)CookieBlockedReason.class));
                    continue block10;
                }
                case "exemptionReason": {
                    exemptionReason = Optional.ofNullable((CookieExemptionReason)((Object)input.read((Type)((Object)CookieExemptionReason.class))));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AssociatedCookie(cookie, blockedReasons, exemptionReason);
    }
}

