/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.storage.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SharedStorageAccessMethod {
    ADDMODULE("addModule"),
    CREATEWORKLET("createWorklet"),
    SELECTURL("selectURL"),
    RUN("run"),
    BATCHUPDATE("batchUpdate"),
    SET("set"),
    APPEND("append"),
    DELETE("delete"),
    CLEAR("clear"),
    GET("get"),
    KEYS("keys"),
    VALUES("values"),
    ENTRIES("entries"),
    LENGTH("length"),
    REMAININGBUDGET("remainingBudget");

    private String value;

    private SharedStorageAccessMethod(String value) {
        this.value = value;
    }

    public static SharedStorageAccessMethod fromString(String s2) {
        return Arrays.stream(SharedStorageAccessMethod.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SharedStorageAccessMethod "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SharedStorageAccessMethod fromJson(JsonInput input) {
        return SharedStorageAccessMethod.fromString(input.nextString());
    }
}

