/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.storage.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v139.storage.model.StorageBucket;
import org.openqa.selenium.devtools.v139.storage.model.StorageBucketsDurability;
import org.openqa.selenium.json.JsonInput;

public class StorageBucketInfo {
    private final StorageBucket bucket;
    private final String id;
    private final TimeSinceEpoch expiration;
    private final Number quota;
    private final Boolean persistent;
    private final StorageBucketsDurability durability;

    public StorageBucketInfo(StorageBucket bucket, String id, TimeSinceEpoch expiration, Number quota, Boolean persistent, StorageBucketsDurability durability) {
        this.bucket = Objects.requireNonNull(bucket, "bucket is required");
        this.id = Objects.requireNonNull(id, "id is required");
        this.expiration = Objects.requireNonNull(expiration, "expiration is required");
        this.quota = Objects.requireNonNull(quota, "quota is required");
        this.persistent = Objects.requireNonNull(persistent, "persistent is required");
        this.durability = Objects.requireNonNull(durability, "durability is required");
    }

    public StorageBucket getBucket() {
        return this.bucket;
    }

    public String getId() {
        return this.id;
    }

    public TimeSinceEpoch getExpiration() {
        return this.expiration;
    }

    public Number getQuota() {
        return this.quota;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public StorageBucketsDurability getDurability() {
        return this.durability;
    }

    private static StorageBucketInfo fromJson(JsonInput input) {
        StorageBucket bucket = null;
        String id = null;
        TimeSinceEpoch expiration = null;
        Number quota = 0;
        Boolean persistent = false;
        StorageBucketsDurability durability = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "bucket": {
                    bucket = (StorageBucket)input.read((Type)((Object)StorageBucket.class));
                    continue block16;
                }
                case "id": {
                    id = input.nextString();
                    continue block16;
                }
                case "expiration": {
                    expiration = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block16;
                }
                case "quota": {
                    quota = input.nextNumber();
                    continue block16;
                }
                case "persistent": {
                    persistent = input.nextBoolean();
                    continue block16;
                }
                case "durability": {
                    durability = (StorageBucketsDurability)((Object)input.read((Type)((Object)StorageBucketsDurability.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StorageBucketInfo(bucket, id, expiration, quota, persistent, durability);
    }
}

