/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class ReverseProxyHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(ReverseProxyHandler.class.getName());
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("connection")).add("http2-settings")).add("keep-alive")).add("proxy-authorization")).add("proxy-authenticate")).add("proxy-connection")).add("te")).add("trailer")).add("transfer-encoding")).add("upgrade")).build();
    private final Tracer tracer;
    private final HttpClient upstream;

    public ReverseProxyHandler(Tracer tracer, HttpClient httpClient) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.upstream = Require.nonNull("HTTP client", httpClient);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "reverse_proxy");){
            Tags.HTTP_REQUEST.accept(span, req);
            HttpRequest toUpstream = new HttpRequest(req.getMethod(), req.getUri());
            for (String attributeName : req.getAttributeNames()) {
                toUpstream.setAttribute(attributeName, req.getAttribute(attributeName));
            }
            for (String name2 : req.getQueryParameterNames()) {
                for (String value2 : req.getQueryParameters(name2)) {
                    toUpstream.addQueryParameter(name2, value2);
                }
            }
            req.forEachHeader((name, value) -> {
                if (IGNORED_REQ_HEADERS.contains(name.toLowerCase(Locale.ENGLISH))) {
                    return;
                }
                toUpstream.addHeader((String)name, (String)value);
            });
            toUpstream.setHeader("Connection", "keep-alive");
            toUpstream.setContent(req.getContent());
            HttpResponse resp = this.upstream.execute(toUpstream);
            Tags.HTTP_RESPONSE.accept(span, resp);
            resp.removeHeader("date");
            resp.removeHeader("server");
            IGNORED_REQ_HEADERS.forEach(x$0 -> {
                HttpResponse cfr_ignored_0 = (HttpResponse)resp.removeHeader((String)x$0);
            });
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
    }
}

